/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree2;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.custom.tree2.TreeNode;
import org.apache.myfaces.custom.tree2.UITreeData;

public class HtmlTree
extends UITreeData {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.Tree2";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.Tree2";
    private static final String NODE_STATE_KEY = "org.apache.myfaces.tree.NODE_STATE_KEY";
    private UICommand _expandControl;
    private String _varNodeToggler;
    private HashSet _expandedNodes = new HashSet();
    private String _selectedNodeId;

    public HtmlTree() {
        this.setRendererType("org.apache.myfaces.Tree2");
        this._expandControl = new HtmlCommandLink();
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._expandedNodes, this._varNodeToggler, this._selectedNodeId};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._expandedNodes = (HashSet)values[1];
        this.setVarNodeToggler((String)values[2]);
        this._selectedNodeId = (String)values[3];
    }

    public void setNodeId(String nodeId) {
        super.setNodeId(nodeId);
        if (this._varNodeToggler != null) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            requestMap.put(this._varNodeToggler, this);
        }
    }

    public void processDecodes(FacesContext context) {
        super.processDecodes(context);
        Map sessionMap = context.getExternalContext().getSessionMap();
        sessionMap.put("org.apache.myfaces.tree.NODE_STATE_KEY:" + this.getId(), this._expandedNodes);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        Map sessionMap = context.getExternalContext().getSessionMap();
        HashSet nodeState = (HashSet)sessionMap.get("org.apache.myfaces.tree.NODE_STATE_KEY:" + this.getId());
        if (nodeState != null) {
            this._expandedNodes = nodeState;
        }
        super.encodeBegin(context);
    }

    public UICommand getExpandControl() {
        return this._expandControl;
    }

    public void setVarNodeToggler(String varNodeToggler) {
        this._varNodeToggler = varNodeToggler;
        String bindingString = "#{" + varNodeToggler + ".toggleExpanded}";
        MethodBinding actionBinding = FacesContext.getCurrentInstance().getApplication().createMethodBinding(bindingString, null);
        this._expandControl.setAction(actionBinding);
    }

    public String toggleExpanded() {
        String nodeId = this.getNodeId();
        if (this._expandedNodes.contains(nodeId)) {
            this._expandedNodes.remove(nodeId);
        } else {
            this._expandedNodes.add(nodeId);
        }
        return null;
    }

    public boolean isNodeExpanded() {
        return this._expandedNodes.contains(this.getNodeId()) && this.getNode().getChildCount() > 0;
    }

    protected void processChildNodes(FacesContext context, TreeNode parentNode, int processAction) {
        super.processChildNodes(context, parentNode, processAction);
    }

    public void setNodeSelected(ActionEvent event) {
        this._selectedNodeId = this.getNodeId();
    }

    public boolean isNodeSelected() {
        return this.getNodeId().equals(this._selectedNodeId);
    }
}

