/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.editors.editparts;

import java.beans.PropertyChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.editors.FacesConfigOperation;
import tk.eclipse.plugin.jsf.editors.editparts.AbstractEntityEditPart;
import tk.eclipse.plugin.jsf.editors.models.ForwardModel;
import tk.eclipse.plugin.jsf.editors.models.PageModel;

public class PageEditPart
extends AbstractEntityEditPart {
    private FacesConfigOperation operation;

    public PageEditPart(IFile file, FacesConfigOperation operation) {
        super(file);
        this.operation = operation;
    }

    protected IFigure createFigure() {
        PageModel model = (PageModel)this.getModel();
        String path = model.getPath();
        if (path.equals("")) {
            path = "<page>";
        }
        Label label = new Label();
        label.setText(path);
        if (this.exists(model.getPath())) {
            label.setIcon(JSFPlugin.getDefault().getImage("__image_page"));
        } else {
            label.setIcon(JSFPlugin.getDefault().getImage("__image_page_warn"));
        }
        label.setTextPlacement(4);
        return label;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        Label label = (Label)this.getFigure();
        PageModel model = (PageModel)this.getModel();
        if (this.exists(model.getPath())) {
            label.setIcon(JSFPlugin.getDefault().getImage("__image_page"));
        } else {
            label.setIcon(JSFPlugin.getDefault().getImage("__image_page_warn"));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        PageModel model;
        super.propertyChange(evt);
        Label label = (Label)this.getFigure();
        String propName = evt.getPropertyName();
        if (propName.equals("__prop_path")) {
            String path = (String)evt.getNewValue();
            if (path.equals("")) {
                path = "<page>";
            }
            label.setText(path);
            this.operation.updateNavigationPath((String)evt.getOldValue(), (String)evt.getNewValue());
        }
        if (this.exists((model = (PageModel)this.getModel()).getPath())) {
            label.setIcon(JSFPlugin.getDefault().getImage("__image_page"));
        } else {
            label.setIcon(JSFPlugin.getDefault().getImage("__image_page_warn"));
        }
        try {
            if (propName.equals("_target_connection")) {
                if (evt.getNewValue() == null) {
                    ForwardModel forward = (ForwardModel)evt.getOldValue();
                    PageModel source = (PageModel)forward.getSource();
                    String fromViewId = source.getPath();
                    String toViewId = model.getPath();
                    this.operation.removeNavigation(fromViewId, toViewId);
                } else {
                    ForwardModel forward = (ForwardModel)evt.getNewValue();
                    PageModel source = (PageModel)forward.getSource();
                    String fromViewId = source.getPath();
                    String toViewId = model.getPath();
                    String fromOutCome = forward.getFromOutcome();
                    String fromAction = forward.getFromAction();
                    this.operation.addNavigation(fromViewId, toViewId, fromOutCome, fromAction);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean exists(String path) {
        try {
            HTMLProjectParams params;
            if (path == null || path.equals("")) {
                return false;
            }
            if (path.indexOf("*") >= 0) {
                return true;
            }
            IProject project = this.getFile().getProject();
            if (project.getFile(new Path((params = new HTMLProjectParams(project)).getRoot()).append(path)).exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

