package net.java.amateras.uml;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class UMLPreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage {

	private Button direct;

	private Button manhattan;

	private Button fan;

	private Button shortest;

	private BooleanFieldEditor booleanEditor;

	private BooleanFieldEditor antiAlias;

	public UMLPreferencePage() {
		super("Amateras UML");
	}

	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		Group group = new Group(composite, SWT.NULL);
		group.setText(UMLPlugin.getDefault().getResourceString(
				"preference.router"));
		group.setLayout(new GridLayout(1, false));

		direct = new Button(group, SWT.RADIO);
		direct.setImage(UMLPlugin.getImageDescriptor("icons/router_direct.gif")
				.createImage());

		manhattan = new Button(group, SWT.RADIO);
		manhattan.setImage(UMLPlugin.getImageDescriptor(
				"icons/router_manhattan.gif").createImage());

		fan = new Button(group, SWT.RADIO);
		fan.setImage(UMLPlugin.getImageDescriptor("icons/router_fan.gif")
				.createImage());

		shortest = new Button(group, SWT.RADIO);
		shortest.setImage(UMLPlugin.getImageDescriptor(
				"icons/router_shortest.gif").createImage());

		Group sequence = new Group(composite, SWT.NULL);
		sequence.setText(UMLPlugin.getDefault().getResourceString(
				"preference.sequence"));
		sequence.setLayout(new GridLayout(1, false));

		booleanEditor = new BooleanFieldEditor(UMLPlugin.PREF_CREATE_RETURN,
				UMLPlugin.getDefault().getResourceString(
						"preference.sequence.returnmessage"), sequence);
		
		antiAlias = new BooleanFieldEditor(UMLPlugin.PREF_ANTI_ALIAS,
				UMLPlugin.getDefault().getResourceString(
						"preference.antialias"), sequence);
		fillInitialValues();

		return composite;
	}

	private void fillInitialValues() {
		IPreferenceStore store = UMLPlugin.getDefault().getPreferenceStore();

		String router = store.getString(UMLPlugin.PREF_CONNECTION_TYPE);
		if (router.equals("manhattan")) {
			manhattan.setSelection(true);
		} else if (router.equals("fan")) {
			fan.setSelection(true);
		} else if (router.equals("shortest")) {
			shortest.setSelection(true);
		} else {
			direct.setSelection(true);
		}
		booleanEditor.setPreferenceStore(store);
		booleanEditor.load();

		antiAlias.setPreferenceStore(store);
		antiAlias.load();
	}

	public boolean performOk() {
		IPreferenceStore store = UMLPlugin.getDefault().getPreferenceStore();

		if (manhattan.getSelection()) {
			store.setValue(UMLPlugin.PREF_CONNECTION_TYPE, "manhattan");
		} else if (fan.getSelection()) {
			store.setValue(UMLPlugin.PREF_CONNECTION_TYPE, "fan");
		} else if (shortest.getSelection()) {
			store.setValue(UMLPlugin.PREF_CONNECTION_TYPE, "shortest");
		} else {
			store.setValue(UMLPlugin.PREF_CONNECTION_TYPE, "direct");
		}
		booleanEditor.store();
		antiAlias.store();
		return true;
	}

	public void init(IWorkbench workbench) {
	}

}
