package net.java.amateras.uml.classdiagram.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.classdiagram.figure.UMLClassFigure;
import net.java.amateras.uml.classdiagram.model.InterfaceModel;
import net.java.amateras.uml.editpart.AbstractUMLEntityEditPart;
import net.java.amateras.uml.model.RootModel;

import org.eclipse.draw2d.IFigure;

public class InterfaceEditPart extends AbstractUMLEntityEditPart {

	protected List getModelChildren() {
		InterfaceModel model = (InterfaceModel)getModel();
		return model.getChildren();
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		super.propertyChange(evt);
		if(evt.getPropertyName().equals(InterfaceModel.P_NAME)){
			RenameUtil.rename(
					(String)evt.getOldValue(),
					(String)evt.getNewValue(),
					(RootModel)getParent().getModel());
		}
		else if (evt.getPropertyName().equals(RootModel.P_CHILDREN)) {
			refreshChildren();
		}
	}
	
	protected IFigure createFigure() {
		InterfaceModel model = (InterfaceModel)getModel();
		
		UMLClassFigure figure =  new UMLClassFigure(
				UMLPlugin.getImageDescriptor("icons/interface.gif").createImage());
		
		figure.setClassName(model.getName());
		
		return figure;
	}

	protected void refreshVisuals() {
		super.refreshVisuals();
		
		UMLClassFigure figure = (UMLClassFigure)getFigure();
		InterfaceModel model = (InterfaceModel)getModel();
		
		figure.setClassName(model.getName());
	}

}
