package net.java.amateras.uml.classdiagram.model;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.EntityModel;
import net.java.amateras.uml.properties.BooleanPropertyDescriptor;

import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * NXfIuWFNgB
 * 
 * @author Naoki Takezoe
 */
public class ClassModel extends AbstractUMLEntityModel implements EntityModel {

	public static final String P_NAME = "_class_name";

	public static final String P_ABSTRACT = "_abstract";

	private String name = "";

	private boolean isAbstract = false;

	private static int number = 1;

	public ClassModel() {
		setName("Class" + number);
		number++;
	}

	public void setName(String className) {
		String oldName = this.name;
		this.name = className;
		firePropertyChange(P_NAME, oldName, className);
	}

	public String getName() {
		return this.name;
	}

	public boolean isAbstract() {
		return isAbstract;
	}

	public void setAbstract(boolean isAbstract) {
		this.isAbstract = isAbstract;
		firePropertyChange(P_ABSTRACT, null, new Boolean(isAbstract));
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		return new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_NAME, UMLPlugin.getDefault()
						.getResourceString("property.name")),
				new BooleanPropertyDescriptor(P_ABSTRACT, UMLPlugin
						.getDefault().getResourceString("property.abstract")),
				new ColorPropertyDescriptor(P_BACKGROUND_COLOR, UMLPlugin
						.getDefault().getResourceString("property.background"))};
	}

	public Object getPropertyValue(Object id) {
		if (id.equals(P_NAME)) {
			return getName();
		} else if (id.equals(P_ABSTRACT)) {
			return new Boolean(isAbstract());
		}
		return super.getPropertyValue(id);
	}

	public boolean isPropertySet(Object id) {
		if (id.equals(P_NAME)) {
			return true;
		} else if (id.equals(P_ABSTRACT)) {
			return true;
		}
		return super.isPropertySet(id);
	}

	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_NAME)) {
			setName((String) value);
		} else if (id.equals(P_ABSTRACT)) {
			setAbstract(((Boolean) value).booleanValue());
		}
		super.setPropertyValue(id, value);
	}

	public String toString() {
		return getName();
	}
}
