package net.java.amateras.uml.classdiagram.model;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.EntityModel;

import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * C^[tF[XfIuWFNgB
 * 
 * @author Naoki Takezoe
 */
public class InterfaceModel extends AbstractUMLEntityModel implements
		EntityModel {

	public static final String P_NAME = "_class_name";

	private String name = "";

	private static int number = 1;

	public InterfaceModel() {
		setName("Interface" + number);
		number++;
	}

	public void setName(String interfaceName) {
		String oldName = this.name;
		this.name = interfaceName;
		firePropertyChange(P_NAME, oldName, interfaceName);
	}

	public String getName() {
		return this.name;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		return new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_NAME, UMLPlugin.getDefault()
						.getResourceString("property.name")),
				new ColorPropertyDescriptor(P_BACKGROUND_COLOR, UMLPlugin
						.getDefault().getResourceString("property.background"))};
	}

	public Object getPropertyValue(Object id) {
		if (id.equals(P_NAME)) {
			return getName();
		}
		return super.getPropertyValue(id);
	}

	public boolean isPropertySet(Object id) {
		if (id.equals(P_NAME)) {
			return true;
		}
		return super.isPropertySet(id);
	}

	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_NAME)) {
			setName((String) value);
		}
		super.setPropertyValue(id, value);
	}

}
