package net.java.amateras.uml.editpart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import net.java.amateras.uml.classdiagram.model.StereoTypeModel;
import net.java.amateras.uml.figure.PresentationFigure;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.model.AbstractUMLModel;

import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractUMLConnectionEditPart extends AbstractConnectionEditPart implements PropertyChangeListener {

	private StereoTypeDirectEditManager directManager;
	
	protected void createEditPolicies() {
    	installEditPolicy(EditPolicy.COMPONENT_ROLE,new EntityComponentEditPolicy());
        installEditPolicy(EditPolicy.CONNECTION_ENDPOINTS_ROLE,new ConnectionEndpointEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new StereoTypeDirectEditPolicy());
	}
	
	public void activate() {
		super.activate();
		((AbstractUMLModel) getModel()).addPropertyChangeListener(this);
	}

	public void deactivate() {
		super.deactivate();
		((AbstractUMLModel) getModel()).removePropertyChangeListener(this);
	}

	
	/** EditPolicy for Entity */
	private class EntityComponentEditPolicy extends ComponentEditPolicy {
		protected Command createDeleteCommand(GroupRequest deleteRequest) {
			DeleteCommand command = new DeleteCommand();
			command.setModel((AbstractUMLConnectionModel)getModel());
		    return command;
		}
	}
	
	/** Delete connection command  */
	private class DeleteCommand extends Command {
		private AbstractUMLConnectionModel model;
		public void setModel(AbstractUMLConnectionModel model){
			this.model = model;
		}
		public void execute() {
			model.detachSource();
			model.detachTarget();
		}
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		refreshVisuals();
	}
	
	protected void refreshVisuals() {
		if (getFigure() instanceof PresentationFigure) {
			PresentationFigure figure = (PresentationFigure) getFigure();
			figure.updatePresentation((AbstractUMLModel) getModel());
		}
		super.refreshVisuals();
	}
	protected Label getStereoTypeLabel(){
		return null;
	}
	
	public void performRequest(Request req) {
		if(getStereoTypeLabel()!=null || getModel() instanceof StereoTypeModel){
			if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
				performDirectEdit();
				return;
			}
		}
		super.performRequest(req);
	}
	
	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new StereoTypeDirectEditManager();
		}
		directManager.show();
	}

	/**
	 * DirectEditManager
	 */
	private class StereoTypeDirectEditManager extends DirectEditManager {
		
		public StereoTypeDirectEditManager() {
			super(AbstractUMLConnectionEditPart.this, TextCellEditor.class, new CompositeCellEditorLocator());
		}
		
		protected void initCellEditor() {
			getCellEditor().setValue(((StereoTypeModel)getModel()).getStereoType());
			Text text = (Text) getCellEditor().getControl();
			text.selectAll();
		}
	}
	
	/**
	 * CellEditorLocator
	 */
	private class CompositeCellEditorLocator implements CellEditorLocator {
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			//Point pref = text.computeSize(-1, -1);
			Rectangle rect = getStereoTypeLabel().getBounds().getCopy();
			figure.translateToAbsolute(rect);
			if(rect.width==0){
				text.setBounds(rect.x - 20, rect.y, 40, rect.height);
			} else {
				text.setBounds(rect.x, rect.y, rect.width, rect.height);
			}
		}
	}
	
	/**
	 * DirectEditCommand
	 */
	private class DirectEditCommand extends Command {
		
		private String oldStereoType;
		private String newStereoType;
		
		public void execute() {
			StereoTypeModel model = (StereoTypeModel)getModel();
			oldStereoType = model.getStereoType();
			model.setStereoType(newStereoType);
		}
		
		public void setStereoType(String stereoType) {
			newStereoType = stereoType;
		}
		
		public void undo() {
			StereoTypeModel model = (StereoTypeModel)getModel();
			model.setStereoType(oldStereoType);
		}
	}
	
	/**
	 * DirectEditPolicy
	 */
	private class StereoTypeDirectEditPolicy extends DirectEditPolicy {
		
		protected Command getDirectEditCommand(DirectEditRequest request) {
			DirectEditCommand command = new DirectEditCommand();
			command.setStereoType((String) request.getCellEditor().getValue());
			return command;
		}
		
		protected void showCurrentEditValue(DirectEditRequest request) {
		}
	}
	

}
