package net.java.amateras.uml.editpart;

import java.beans.PropertyChangeEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.NoteModel;
import net.java.amateras.uml.model.RootModel;

import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.SWT;

public class RootEditPart extends AbstractUMLEditPart {
	
	private Set RESIZABLE = null;
	{
		RESIZABLE = new HashSet();
		RESIZABLE.add(NoteModel.class);
	}
	protected void addResizableClass(Class c) {
		RESIZABLE.add(c);
	}
	
	protected IFigure createFigure() {
		Layer figure = new Layer() {
			public void paint(Graphics graphics) {
				if (UMLPlugin.getDefault().getPreferenceStore().getBoolean(UMLPlugin.PREF_ANTI_ALIAS)) {
					graphics.setAntialias(SWT.ON);
					graphics.setTextAntialias(SWT.ON);
				}
				super.paint(graphics);
			}
		};
		figure.setLayoutManager(new XYLayout());
		
		ConnectionLayer layer = (ConnectionLayer) getLayer(LayerConstants.CONNECTION_LAYER);
		if ("manhattan".equals(UMLPlugin.getDefault().getConnectionRouter())) {
			layer.setConnectionRouter(new ManhattanConnectionRouter());
		} else if ("fan".equals(UMLPlugin.getDefault().getConnectionRouter())) {
			FanRouter router = new FanRouter();
			router.setSeparation(40);
			layer.setConnectionRouter(router);
		} else if ("shortest".equals(UMLPlugin.getDefault().getConnectionRouter())) {
			ShortestPathConnectionRouter router = new ShortestPathConnectionRouter(figure);
			layer.setConnectionRouter(router);
		} else {
			layer.setConnectionRouter(ConnectionRouter.NULL);
		}
		return figure;
	}
	
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new RootEditPolicy());
	}
	
	protected List getModelChildren() {
		return ((RootModel)getModel()).getChildren();
//		ArrayList models = new ArrayList();
//		for(int i=0;i<list.size();i++){
//			Object obj = list.get(i);
//			if(obj instanceof AbstractUMLModel){
//				models.add(obj);
//			}
//		}
//		return models;
	}
	
//	protected void refreshVisuals(){
//		List list = getChildren();
//		for(int i=0;i<list.size();i++){
//			Object obj = list.get(i);
//			if(obj instanceof PageEditPart){
//				((PageEditPart)obj).refreshVisuals();
//			}
//		}
//	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals(RootModel.P_CHILDREN)) {
			refreshChildren();
		}
	}
	
	/** GfBbg|V[ */
	private class RootEditPolicy extends XYLayoutEditPolicy {


		protected EditPolicy createChildEditPolicy(EditPart child) {
			if (RESIZABLE.contains(child.getModel().getClass())) {
				return new ResizableEditPolicy();
			} else {
				return new NonResizableEditPolicy();
			}
		}
		
		protected Command createAddCommand(EditPart child, Object constraint) {
			return null;
		}
		
		protected Command createChangeConstraintCommand(EditPart child,Object constraint) {
			ChangeConstraintCommand command = new ChangeConstraintCommand();
			command.setModel((AbstractUMLEntityModel)child.getModel());
			command.setConstraint((Rectangle)constraint);
			return command;
		}
		
		protected Command getCreateCommand(CreateRequest request) {
			CreateCommand command = new CreateCommand();
			Rectangle constraint = (Rectangle) getConstraintFor(request);
			AbstractUMLEntityModel model = (AbstractUMLEntityModel) request.getNewObject();
			if (!RESIZABLE.contains(model.getClass())) {
				constraint.width = -1;
				constraint.height = -1;
			}
			model.setConstraint(constraint);
			
			command.setRootModel(getHost().getModel());
			command.setModel(model);
			return command;
		}
		
		protected Command getDeleteDependantCommand(Request request) {
			return null;
		}
	}
	
	/** ̕ύXR}h */
	private class ChangeConstraintCommand extends Command {
		
		private AbstractUMLEntityModel model;
		private Rectangle constraint;
		private Rectangle oldConstraint;
		
		public void execute(){
			model.setConstraint(constraint);
		}
		
		public void setConstraint(Rectangle constraint){
			this.constraint = constraint;
		}
		
		public void setModel(AbstractUMLEntityModel model){
			this.model = model;
			oldConstraint = model.getConstraint();
		}
		
		public void undo() {
			model.setConstraint(oldConstraint);
		}
	}
	
	/** f̐VK쐬R}h */
	private class CreateCommand extends Command {
		
		private RootModel root;
		private AbstractUMLEntityModel model;
		
		public void execute() {
			root.copyPresentation(model);
			root.addChild(model);
		}
		
		public void setRootModel(Object root) {
			this.root = (RootModel)root;
		}
		
		public void setModel(Object model) {
			this.model = (AbstractUMLEntityModel) model;
		}
		
		public void undo() {
			root.removeChild(model);
		}
	}

}
