package net.java.amateras.uml.model;

import net.java.amateras.uml.UMLPlugin;

import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class AbstractUMLConnectionModel extends AbstractUMLModel {
	
	private AbstractUMLEntityModel source;
	private AbstractUMLEntityModel target;
	
	// ̃RlNV̍sourceɐڑ
	public void attachSource() {
		// ̃RlNVɐڑĂꍇ͖
		if (!source.getModelSourceConnections().contains(this)){
			source.addSourceConnection(this);
		}
	}
	
	// ̃RlNV̐[targetɐڑ
	public void attachTarget() {
		if (!target.getModelTargetConnections().contains(this)){
			target.addTargetConnection(this);
		}
	}
	
	// ̃RlNV̍sourceO
	public void detachSource() {
		if(source!=null){
			source.removeSourceConnection(this);
		}
	}
	
	// ̃RlNV̐[targetO
	public void detachTarget() {
		if(target!=null){
			target.removeTargetConnection(this);
		}
	}
	
	public AbstractUMLEntityModel getSource() {
		return source;
	}
	
	public AbstractUMLEntityModel getTarget() {
		return target;
	}
	
	public void setSource(AbstractUMLEntityModel model) {
		source = model;
	}
	
	public void setTarget(AbstractUMLEntityModel model) {
		target = model;
	}
	
	public Object getEditableValue() {
		return this;
	}
	
	public IPropertyDescriptor[] getPropertyDescriptors() {
		return new IPropertyDescriptor[] {
				new ColorPropertyDescriptor(P_FOREGROUND_COLOR, UMLPlugin
						.getDefault().getResourceString("property.foreground"))
		};
	}
	
	
}
