package net.java.amateras.uml.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.OperationModel;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractUMLEntityModel extends AbstractUMLModel {
	
	private Rectangle constraint;
	// ̃fLтĂRlNṼXg
	private List sourceConnections = new ArrayList();
	// ̃fɌĒĂRlNṼXg
	private List targetConnections = new ArrayList();
	
	private List children = new ArrayList();
	
	public static final String P_CONSTRAINT = "_constraint";
	public static final String P_SOURCE_CONNECTION = "_source_connection";
	public static final String P_TARGET_CONNECTION = "_target_connection";
	public static final String P_CHILDREN = "_children";
		
	public Rectangle getConstraint() {
		return constraint;
	}
	
	public void addChild(Object obj) {
		children.add(obj);
	}
	
	public void removeChild(Object obj) {
		children.remove(obj);
	}
	
	public void addOperation(OperationModel model){
		this.children.add(model);
		firePropertyChange(P_CHILDREN,null,model);
	}
	
	public void addAttribute(AttributeModel model){
		this.children.add(model);
		firePropertyChange(P_CHILDREN,null,model);
	}
	
	public void removeOperation(OperationModel model){
		this.children.remove(model);
		firePropertyChange(P_CHILDREN,null,model);
	}
	
	public void removeAttribute(AttributeModel model){
		this.children.remove(model);
		firePropertyChange(P_CHILDREN,null,model);
	}
	
	public List getChildren(){
		return this.children;
	}
	
	public void setConstraint(Rectangle constraint) {
		this.constraint = constraint;
		firePropertyChange(P_CONSTRAINT, null, constraint);
	}
	
	/** ̃foRlNV f̒ǉ */
	public void addSourceConnection(Object connx) {
		sourceConnections.add(connx);
		firePropertyChange(P_SOURCE_CONNECTION, null, connx);
	}
	
	/** ̃fɐڑRlNV f̒ǉ */
	public void addTargetConnection(Object connx) {
		targetConnections.add(connx);
		firePropertyChange(P_TARGET_CONNECTION, null, connx);
	}
	
	/** ̃fڑƂRlNṼXgԂ */
	public List getModelSourceConnections() {
		return sourceConnections;
	}
	
	/** ̃fڑƂRlNṼXgԂ */
	public List getModelTargetConnections() {
		return targetConnections;
	}
	
	/** ̃fRlNṼ\[X؂藣 */
	public void removeSourceConnection(Object connx) {
		sourceConnections.remove(connx);
		firePropertyChange(P_SOURCE_CONNECTION, connx, null);
	}
	
	/** ̃fRlNṼ^[Qbg؂藣 */
	public void removeTargetConnection(Object connx) {
		targetConnections.remove(connx);
		firePropertyChange(P_TARGET_CONNECTION, connx, null);
	}
	
	public void setBackgroundColor(RGB backgroundColor) {
		for (Iterator iter = children.iterator(); iter.hasNext();) {
			AbstractUMLModel element = (AbstractUMLModel) iter.next();
			element.setBackgroundColor(backgroundColor);
		}
		super.setBackgroundColor(backgroundColor);
	}
	
	public void setForegroundColor(RGB foregroundColor) {
		for (Iterator iter = children.iterator(); iter.hasNext();) {
			AbstractUMLModel element = (AbstractUMLModel) iter.next();
			element.setForegroundColor(foregroundColor);
		}
		super.setForegroundColor(foregroundColor);
	}
	
	public void setShowIcon(boolean showIcon) {
		for (Iterator iter = children.iterator(); iter.hasNext();) {
			AbstractUMLModel element = (AbstractUMLModel) iter.next();
			element.setShowIcon(showIcon);
		}
		super.setShowIcon(showIcon);
	}
}
