package net.java.amateras.uml.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.properties.BooleanPropertyDescriptor;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

/**
 * UMLGfB^̃[gfIuWFNgB
 * 
 * @author Naoki Takezoe
 */
public class RootModel extends AbstractUMLModel {

	public static final String P_CHILDREN = "_children";

	private ArrayList children = new ArrayList();

	public void setBackgroundColor(RGB backgroundColor) {
		super.setBackgroundColor(backgroundColor);
		for (Iterator iter = children.iterator(); iter.hasNext();) {
			AbstractUMLEntityModel element = (AbstractUMLEntityModel) iter
					.next();
			element.setBackgroundColor(backgroundColor);
			List connections = element.getModelSourceConnections();
			for (Iterator iterator = connections.iterator(); iterator.hasNext();) {
				AbstractUMLConnectionModel connection = (AbstractUMLConnectionModel) iterator
						.next();
				connection.setBackgroundColor(backgroundColor);
			}
		}
	}

	public void setForegroundColor(RGB foregroundColor) {
		super.setForegroundColor(foregroundColor);
		for (Iterator iter = children.iterator(); iter.hasNext();) {
			AbstractUMLEntityModel element = (AbstractUMLEntityModel) iter
					.next();
			element.setForegroundColor(foregroundColor);
			List connections = element.getModelSourceConnections();
			for (Iterator iterator = connections.iterator(); iterator.hasNext();) {
				AbstractUMLConnectionModel connection = (AbstractUMLConnectionModel) iterator
						.next();
				connection.setForegroundColor(foregroundColor);
			}
		}
	}

	public void setShowIcon(boolean showIcon) {
		super.setShowIcon(showIcon);
		for (Iterator iter = children.iterator(); iter.hasNext();) {
			AbstractUMLEntityModel element = (AbstractUMLEntityModel) iter
					.next();
			element.setShowIcon(showIcon);
		}
	}

	public void addChild(Object child) {
		children.add(child);
		firePropertyChange(P_CHILDREN, null, child);
	}

	public List getChildren() {
		return children;
	}

	public void removeChild(Object obj) {
		children.remove(obj);
		firePropertyChange(P_CHILDREN, obj, null);
	}

	public void removeAll() {
		children.clear();
		firePropertyChange(P_CHILDREN, null, null);
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		return new IPropertyDescriptor[] {
				new ColorPropertyDescriptor(P_BACKGROUND_COLOR, UMLPlugin
						.getDefault().getResourceString("property.background")),
				new BooleanPropertyDescriptor(P_SHOW_ICON, UMLPlugin
						.getDefault().getResourceString("property.showicon")) };
	}
	// public boolean equals(Object obj){
	// if(obj instanceof RootModel){
	// return true;
	// }
	// return false;
	// }
}
