/**
 * 
 */
package net.java.amateras.uml.sequencediagram.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.geometry.Rectangle;

/**
 * @author Takahiro Shida.
 * 
 */
public class ActivationModel extends MessageAcceptableModel {

	public static final String P_SOURCE_CONNECTION = "_source_connection";

	public static final String P_TARGET_CONNECTION = "_target_connection";

	public static final String P_CHILDREN = "_children";

	public static final int DEFAULT_WIDTH = 10;

	public static final int DEFAULT_HEIGHT = 20;

	private ActivationModel owner;

	private LifeLineModel ownerLine;

	private boolean movable = true;
	
	
	public boolean isMovable() {
		return movable;
	}

	public void setMovable(boolean movable) {
		this.movable = movable;
	}

	public void addActivation(ActivationModel model) {
		addChild(model);
		this.ownerLine.getOwner().getRoot().addActivation(model);
		model.setOwner(this);
		model.setOwnerLine(this.ownerLine);
		firePropertyChange(P_CHILDREN, null, model);
	}

	public void removeActivation(ActivationModel model) {
		removeChild(model);
		this.ownerLine.getOwner().getRoot().removeActivation(model);
	}

	public void setOwner(ActivationModel owner) {
		this.owner = owner;
	}

	public void setOwnerLine(LifeLineModel lineModel) {
		this.ownerLine = lineModel;
	}

	public LifeLineModel getOwnerLine() {
		return ownerLine;
	}

	public ActivationModel getOwner() {
		return owner;
	}

	public InteractionModel getRoot() {
		return ownerLine.getOwner().getRoot();
	}

	/**
	 * 
	 */
	public void setConstraint(Rectangle constraint) {
		Rectangle old = getConstraint();
		if (old != null) {
			//ړ̐.ĂяoɈړłȂ.
			List targetConnection = getSyncTargetConnection();
			for (Iterator iter = targetConnection.iterator(); iter.hasNext();) {
				SyncMessageModel element = (SyncMessageModel) iter.next();
				ActivationModel source = (ActivationModel) element.getSource();
				if (constraint.y < source.getConstraint().y) {
					constraint.y = source.getConstraint().y;
				}
				//ȌĂяȍꍇ͂ɌĂяo + ɈړłȂ.
				if (element.isRecursive()) {
					if (constraint.y < source.getConstraint().y + SyncMessageModel.DELTA_Y) {
						constraint.y = source.getConstraint().y + SyncMessageModel.DELTA_Y;
					}
				}
			}
			Rectangle delta = new Rectangle();
			delta.x = constraint.x - old.x;
			delta.y = constraint.y - old.y;
			delta.width = constraint.width - old.width;
			delta.height = constraint.height - old.height;
			List list = getSyncSourceConnection();
			for (Iterator iter = list.iterator(); iter.hasNext();) {
				SyncMessageModel element = (SyncMessageModel) iter.next();
				element.updateCallee(delta);
			}
		}
		super.setConstraint(constraint);
		computeCaller();
	}

	/**
	 * ړqԂɔf.
	 * @param delta
	 */
	public void adjustLocation(Rectangle delta) {
		Rectangle rectangle = getConstraint();
		if (rectangle != null) {
			rectangle.translate(delta.getLocation());
			rectangle.translate(delta.width / 2, 0);
			setConstraint(rectangle);
		}
		for (Iterator iter = getChildren().iterator(); iter.hasNext();) {
			ActivationModel element = (ActivationModel) iter.next();
			element.adjustLocation(delta);
		}
	}

	/**
	 * eƎq犈Ԃ̃TCY𒲐.
	 *
	 */
	public void computeSize() {
		Rectangle rectangle = getConstraint();
		if (rectangle != null) {
			rectangle.height = getChildrenSize() - rectangle.y;
			super.setConstraint(rectangle);
			computeOwner();
		}
	}

	/**
	 * qԂ̃TCY擾.
	 * @return
	 */
	private int getChildrenSize() {
		int max = getConstraint().y + DEFAULT_HEIGHT;
		for (Iterator iter = getChildren().iterator(); iter.hasNext();) {
			ActivationModel element = (ActivationModel) iter.next();
			int cmax = element.getConstraint().y
					+ element.getConstraint().height;
			if (max < cmax) {
				max = cmax;
			}
		}
		int callee = getCalleeSize();
		if (max > callee) {
			return max + 10;
		} else {
			return callee;
		}
	}

	/**
	 * e/CtC̃TCY𒲐.
	 *
	 */
	public void computeOwner() {
		if (owner != null) {
			owner.computeSize();
		} else {
			if (ownerLine != null) {
				ownerLine.computeSize();
			}
		}
	}

//	/**
//	 * qԂ̃TCYvZ.
//	 * @return
//	 */
//	public int computeChild() {
//		Rectangle rectangle = getConstraint();
//
//		List list = getSyncSourceConnection();
//		int max = rectangle.y + ActivationModel.DEFAULT_HEIGHT;
//		for (Iterator iter = list.iterator(); iter.hasNext();) {
//			SyncMessageModel element = (SyncMessageModel) iter.next();
//			ActivationModel target = (ActivationModel) element.getTarget();
//			ActivationModel model = (ActivationModel) target;
//			int child = model.computeChild();
//			if (child > max) {
//				max = child + 10;
//			}
//		}
//		if (rectangle != null) {
//			rectangle.height = max - rectangle.y;
//			super.setConstraint(rectangle);
//			computeOwner();
//		}
//		return max;
//	}

	/**
	 * ĂяõTCY𒲐.
	 *
	 */
	public void computeCaller() {
		//q̍őTCY擾.
		int size = getCalleeSize();
		Rectangle rectangle = getConstraint().getCopy();
		rectangle.height = size - rectangle.y;
		super.setConstraint(rectangle);
		//Ăяoɒʒm.
		List list = getSyncTargetConnection();
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			SyncMessageModel element = (SyncMessageModel) iter.next();
			element.updateCaller(size);
		}
		if (!movable) {
			List connections = getOwnerLine().getOwner().getModelTargetConnections();
			if (!connections.isEmpty()) {
				SyncMessageModel model = (SyncMessageModel) connections.get(0);
				model.updateCaller(size);
			}
		}
	}

	/**
	 * ĂяõTCY𒲐.
	 * @param size
	 */
	public void computeCaller(int size) {
		Rectangle rectangle = getConstraint();
		if (rectangle != null) {
			int max = size;
			int calleeSize = getCalleeSize();
			if (size < calleeSize) {
				max = calleeSize;
			}
			rectangle.height = max - rectangle.y;
			super.setConstraint(rectangle);	
			//Ăяoɒʒm.
			List list = getSyncTargetConnection();
			for (Iterator iter = list.iterator(); iter.hasNext();) {
				SyncMessageModel element = (SyncMessageModel) iter.next();
				element.updateCaller(max);
			}
			if (!movable) {
				List connections = getOwnerLine().getOwner().getModelTargetConnections();
				if (!connections.isEmpty()) {
					SyncMessageModel model = (SyncMessageModel) connections.get(0);
					model.updateCaller(size);
				}
			}
		}
	}

	/**
	 * \bhK.Ăяo֌WTCY𒲐.
	 * @param delta
	 */
	public void updateLocation(Rectangle delta) {
		Rectangle rectangle = getConstraint();
		if (rectangle != null) {
			rectangle.translate(0, delta.getLocation().y);
			super.setConstraint(rectangle);
		}
		List list = getSyncSourceConnection();
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			SyncMessageModel element = (SyncMessageModel) iter.next();
			element.updateCallee(delta);
		}
	}

	/**
	 * bZ[Ŵݕԋp.
	 * @return
	 */
	public List getSyncSourceConnection() {
		List modelSourceConnections = getModelSourceConnections();
		List rv = new ArrayList();
		for (Iterator iter = modelSourceConnections.iterator(); iter.hasNext();) {
			Object element = (Object) iter.next();
			if (element instanceof SyncMessageModel) {
				rv.add(element);
			}
		}
		return rv;
	}

	/**
	 * bZ[Ŵݕԋp.
	 * @return
	 */
	public List getSyncTargetConnection() {
		List modelTargetConnections = getModelTargetConnections();
		List rv = new ArrayList();
		for (Iterator iter = modelTargetConnections.iterator(); iter.hasNext();) {
			Object element = (Object) iter.next();
			if (element instanceof SyncMessageModel) {
				rv.add(element);
			}
		}
		return rv;
	}
	
	public int getNestLevel() {
		if (owner == null) {
			return 1;
		} else {
			return owner.getNestLevel() + 1;
		}
	}

	public int getCalleeSize() {
		int max = getConstraint().y + ActivationModel.DEFAULT_HEIGHT;
		List connection = getSyncSourceConnection();
		for (Iterator iter = connection.iterator(); iter.hasNext();) {
			SyncMessageModel element = (SyncMessageModel) iter.next();
			int size = element.getCalleeSize();
			if (max < size) {
				max = size;
			}
		}
		return max + 10;
	}
		
}
