package net.java.amateras.uml.usecasediagram;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.action.AbstractUMLEditorAction;
import net.java.amateras.uml.action.OpenOutlineViewAction;
import net.java.amateras.uml.action.OpenPropertyViewAction;
import net.java.amateras.uml.action.SaveAsImageAction;
import net.java.amateras.uml.model.AnchorModel;
import net.java.amateras.uml.model.NoteModel;
import net.java.amateras.uml.model.RootModel;
import net.java.amateras.uml.usecasediagram.edit.UsecaseEditPartFactory;
import net.java.amateras.uml.usecasediagram.model.UsecaseModel;
import net.java.amateras.uml.usecasediagram.model.UsecaseRootModel;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/**
 * GEFgpUMLi[XP[X_CAOjGfB^B
 * 
 * @author Naoki Takezoe
 */
public class UsecaseDiagramEditor extends GraphicalEditorWithPalette {
	
	private boolean savePreviouslyNeeded = false;
	private AbstractUMLEditorAction openOutlineAction  = null;
	private AbstractUMLEditorAction openPropertyAction = null;
	private AbstractUMLEditorAction saveAsImageAction  = null;
	
	private PropertyChangeListener usecaseDiagramListener;
	
	public UsecaseDiagramEditor() {
		super();
		setEditDomain(new DefaultEditDomain(this));
		getActionRegistry().registerAction(new UndoRetargetAction());
		getActionRegistry().registerAction(new RedoRetargetAction());
		getActionRegistry().registerAction(new DeleteRetargetAction());
	}

	public void setUsecaseDiagramListener(
			PropertyChangeListener usecaseDiagramListener) {
		this.usecaseDiagramListener = usecaseDiagramListener;
	}
	
	protected PaletteRoot getPaletteRoot() {
		PaletteRoot root = new PaletteRoot();
		UMLPlugin plugin = UMLPlugin.getDefault();
		
		// f쐬ȊÕc[i[O[v
		PaletteGroup tools = new PaletteGroup(plugin.getResourceString("palette.tool"));
		// 'I' c[̍쐬ƒǉ
		ToolEntry tool = new SelectionToolEntry();
		tools.add(tool);
		root.setDefaultEntry(tool);
		// '͂ݘg' c[̍쐬ƒǉ
		tool = new MarqueeToolEntry();
		tools.add(tool);
		
		PaletteDrawer common = new PaletteDrawer(plugin.getResourceString("palette.common"));
		common.add(createEntityEntry(plugin.getResourceString("palette.common.note"),
				NoteModel.class,"icons/note.gif"));
		common.add(createConnectionEntry(plugin.getResourceString("palette.common.anchor"),
				AnchorModel.class,"icons/anchor.gif"));
		
		// f̍쐬sc[i[O[v
		PaletteDrawer entities = new PaletteDrawer(plugin.getResourceString("palette.entity"));
		entities.add(createEntityEntry(plugin.getResourceString("palette.entity.class"),
				UsecaseModel.class,"icons/class.gif"));

		PaletteDrawer relations = new PaletteDrawer(plugin.getResourceString("palette.relation"));
		
		// 쐬3̃O[v[gɒǉ
		root.add(tools);
		root.add(common);
		root.add(entities);
		root.add(relations);
		
		return root;
	}

	protected void initializeGraphicalViewer() {
		GraphicalViewer viewer = getGraphicalViewer();
//		IFile file = ((IFileEditorInput)getEditorInput()).getFile();
		UsecaseRootModel root = null;
//		if(file.exists()){
//			try {
//				root = ClassDiagramSerializer.deserialize(file.getContents());
//			} catch(Exception ex){
//				// ignore
//			}
//		}
		if(root == null){
			root = new UsecaseRootModel();
		}
		viewer.setContents(root);
		System.out.println("foo");
		if (usecaseDiagramListener != null) {
			System.out.println("hoge");
			root.addPropertyChangeListener(usecaseDiagramListener);
		}
	}

	
	protected void configureGraphicalViewer() {
		super.configureGraphicalViewer();
		GraphicalViewer viewer = getGraphicalViewer();
		viewer.setEditPartFactory(new UsecaseEditPartFactory());
		
		ScalableRootEditPart rootEditPart = new ScalableRootEditPart();
		viewer.setRootEditPart(rootEditPart);
		
	    // ZoomManager̎擾
	    ZoomManager manager = rootEditPart.getZoomManager();
	    
	    // Y[x̐ݒ
	    double[] zoomLevels = new double[] {
	      0.25,0.5,0.75,1.0,1.5,2.0,2.5,3.0,4.0,5.0,10.0,20.0
	    };
	    manager.setZoomLevels(zoomLevels);
	    
	    // Y[ x Rgr[V̐ݒ
	    ArrayList zoomContributions = new ArrayList();
	    zoomContributions.add(ZoomManager.FIT_ALL);
	    zoomContributions.add(ZoomManager.FIT_HEIGHT);
	    zoomContributions.add(ZoomManager.FIT_WIDTH);
	    manager.setZoomLevelContributions(zoomContributions);
	    // gANV̍쐬Ɠo^
	    getActionRegistry().registerAction(new ZoomInAction(manager));
	    // kANV̍쐬Ɠo^
	    getActionRegistry().registerAction(new ZoomOutAction(manager));
		
        getGraphicalViewer().setKeyHandler(
                new GraphicalViewerKeyHandler(getGraphicalViewer()));
        
	    // ReNXgj[̍쐬
	    String menuId = this.getClass().getName() + ".EditorContext";
	    
	    
		MenuManager menuMgr = new MenuManager(menuId, menuId);
		openPropertyAction = new OpenPropertyViewAction(viewer);
		openOutlineAction  = new OpenOutlineViewAction(viewer);
		saveAsImageAction  = new SaveAsImageAction(viewer);
		
		getSite().registerContextMenu(menuId, menuMgr, viewer);
		
		PrintAction printAction = new PrintAction(this);
		getActionRegistry().registerAction(printAction);
		
		final DeleteAction deleteAction = new DeleteAction((IWorkbenchPart) this);
		deleteAction.setSelectionProvider(getGraphicalViewer());
		getActionRegistry().registerAction(deleteAction);
		getGraphicalViewer().addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				deleteAction.update();
			}
		});
		
		menuMgr.add(new Separator("edit"));
		menuMgr.add(getActionRegistry().getAction(ActionFactory.DELETE.getId()));
		menuMgr.add(getActionRegistry().getAction(ActionFactory.UNDO.getId()));
		menuMgr.add(getActionRegistry().getAction(ActionFactory.REDO.getId()));
		menuMgr.add(new Separator("zoom"));
		menuMgr.add(getActionRegistry().getAction(GEFActionConstants.ZOOM_IN));
		menuMgr.add(getActionRegistry().getAction(GEFActionConstants.ZOOM_OUT));
		menuMgr.add(new Separator("add"));
		menuMgr.add(new Separator("print"));
		menuMgr.add(saveAsImageAction);
		menuMgr.add(printAction);
		menuMgr.add(new Separator("views"));
		menuMgr.add(openPropertyAction);
		menuMgr.add(openOutlineAction);
		menuMgr.add(new Separator("generate"));
		menuMgr.add(new Separator("additions"));
		viewer.setContextMenu(menuMgr);
	}

	protected void setInput(IEditorInput input) {
		super.setInput(input);
		setPartName(input.getName());
	}

	public void doSave(IProgressMonitor monitor) {
//		try {
//			IEditorInput input = getEditorInput();
//			if(input instanceof IFileEditorInput){
//				IFile file = ((IFileEditorInput)input).getFile();
//				file.setContents(ClassDiagramSerializer.serialize((RootModel)getGraphicalViewer().getContents().getModel()),
//						true,true,monitor);
//			}
//		} catch(Exception ex){
//			ex.printStackTrace();
//		}
		getCommandStack().markSaveLocation();
	}

	public void doSaveAs() {
		doSave(new NullProgressMonitor());
	}

	public boolean isSaveAsAllowed() {
		return true;
	}
	
	public void commandStackChanged(EventObject event) {
		if (isDirty()) {
			if (!savePreviouslyNeeded()) {
				setSavePreviouslyNeeded(true);
				firePropertyChange(IEditorPart.PROP_DIRTY);
			}
		} else {
			setSavePreviouslyNeeded(false);
			firePropertyChange(IEditorPart.PROP_DIRTY);
		}
		super.commandStackChanged(event);
	}

	private void setSavePreviouslyNeeded(boolean value) {
		this.savePreviouslyNeeded = value;
	}
	
	private boolean savePreviouslyNeeded() {
		return this.savePreviouslyNeeded;
	}

	/**
	 * GeBeBpPaletteEntry쐬܂B
	 * 
	 * @param itemName pbgɕ\ACe
	 * @param clazz f̃NX
	 * @param icon pbgɕ\ACR̃pX
	 * @return PaletteEntry
	 */
	private PaletteEntry createEntityEntry(String itemName,Class clazz,String icon){
		CreationToolEntry entry = new CreationToolEntry(
				itemName,
				itemName,
				new SimpleFactory(clazz),
				UMLPlugin.getImageDescriptor(icon),
				UMLPlugin.getImageDescriptor(icon));
		return entry;
	}
	
	/**
	 * RlNVpPaletteEntry쐬܂B
	 * 
	 * @param itemName pbgɕ\ACe
	 * @param clazz f̃NX
	 * @param icon pbgɕ\ACR̃pX
	 * @return PaletteEntry
	 */
	private PaletteEntry createConnectionEntry(String itemName,Class clazz,String icon){
		ConnectionCreationToolEntry entry = new ConnectionCreationToolEntry(
				itemName,
				itemName,
				new SimpleFactory(clazz),
				UMLPlugin.getImageDescriptor(icon),
				UMLPlugin.getImageDescriptor(icon));
		return entry;
	}
	
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		super.selectionChanged(part,selection);
		openPropertyAction.update((IStructuredSelection)selection);
		openOutlineAction.update((IStructuredSelection)selection);
		saveAsImageAction.update((IStructuredSelection)selection);
	}
	
	public Object getAdapter(Class type) {
		if (type == ZoomManager.class){
			return ((ScalableRootEditPart) getGraphicalViewer().getRootEditPart()).getZoomManager();
		}
		if (type == IContentOutlinePage.class) {
			return new UMLContentOutlinePage();
		}
		if (type == RootModel.class){
			return getGraphicalViewer().getContents().getModel();
		}
		return super.getAdapter(type);
	}
	
	/**
	 * UMLGfB^̃AEgCy[WB
	 * _CAÕTlC\܂B
	 */
	private class UMLContentOutlinePage implements IContentOutlinePage {
		
		private Canvas canvas;
		private ScrollableThumbnail thumbnail;
		private DisposeListener disposeListener;
		
		public void createControl(Composite parent) {
			this.canvas = new Canvas(parent, SWT.BORDER);
			LightweightSystem lws = new LightweightSystem(canvas);
			
			// RootEditPart̃r[\[XƂăTlC쐬
			ScalableRootEditPart rootEditPart = (ScalableRootEditPart)getGraphicalViewer().getRootEditPart();
			this.thumbnail = new ScrollableThumbnail((Viewport)rootEditPart.getFigure());
			this.thumbnail.setSource(rootEditPart.getLayer(LayerConstants.PRINTABLE_LAYERS));
			lws.setContents(thumbnail);
			
			// C[Wj邽߂̃Xi
			disposeListener = new DisposeListener() {
				public void widgetDisposed(DisposeEvent e) {
					if (thumbnail != null) {
						thumbnail.deactivate();
						thumbnail = null;
					}
				}
			};
			
			// OtBJEr[jƂɃTlCj
			getGraphicalViewer().getControl().addDisposeListener(disposeListener);
		}
		
		public Control getControl(){
			return this.canvas;
		}
		
		public void dispose() {
			if (getGraphicalViewer().getControl() != null && !getGraphicalViewer().getControl().isDisposed()){
				getGraphicalViewer().getControl().removeDisposeListener(disposeListener);
			}
		}

		public void setActionBars(IActionBars actionBars) {
			// nothing to do
		}

		public void setFocus() {
			// nothing to do
		}

		public void addSelectionChangedListener(ISelectionChangedListener listener) {
			// nothing to do
		}

		public ISelection getSelection() {
			// nothing to do
			return null;
		}

		public void removeSelectionChangedListener(ISelectionChangedListener listener) {
			// nothing to do
		}

		public void setSelection(ISelection selection) {
			// nothing to do
		}
	}
	

}
