/**
 * 
 */
package net.java.amateras.uml.dnd.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import net.java.amateras.uml.classdiagram.model.Argument;
import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.ClassModel;
import net.java.amateras.uml.classdiagram.model.InterfaceModel;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.classdiagram.model.Visibility;
import net.java.amateras.uml.model.AbstractUMLEntityModel;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

class ClassModelConverter implements CreationFactory {

	/**
	 * 
	 */
	ICompilationUnit unit;

	public ClassModelConverter(ICompilationUnit unit) {
		this.unit = unit;
	}

	public Object getNewObject() {
		if (unit == null) {
			return new ClassModel();
		}
		try {
			AbstractUMLEntityModel rv = null;
			unit.save(new NullProgressMonitor(), true);
			IType[] types = unit.getTypes();
			IType type = types[0];
			if (type.isInterface()) {
				rv = new InterfaceModel();
				((InterfaceModel) rv).setName(type.getFullyQualifiedName());
			} else if (type.isClass()) {
				rv = new ClassModel();
				((ClassModel) rv).setName(type.getFullyQualifiedName());
			}
			IField[] fields = type.getFields();
			for (int i = 0; i < fields.length; i++) {
				IField field = fields[i];
				if (rv instanceof InterfaceModel) {
					AttributeModel model = new AttributeModel();
					model.setStatic(true);
					model.setVisibility(Visibility.PUBLIC);
					model.setName(field.getElementName());
					model.setType(Signature.toString(field
							.getTypeSignature()));
					rv.addAttribute(model);
				} else {
					AttributeModel model = new AttributeModel();
					model.setStatic(Flags.isStatic(field.getFlags()));
					if (Flags.isPrivate(field.getFlags())) {
						model.setVisibility(Visibility.PRIVATE);
					} else if (Flags.isProtected(field.getFlags())) {
						model.setVisibility(Visibility.PROTECTED);
					} else if (Flags.isPublic(field.getFlags())) {
						model.setVisibility(Visibility.PUBLIC);
					} else {
						model.setVisibility(Visibility.PACKAGE);
					}
					model.setName(field.getElementName());
					model.setType(Signature.toString(field
							.getTypeSignature()));
					rv.addAttribute(model);
				}
			}
			
			List methods = getMethods(type);
			for (Iterator iter = methods.iterator(); iter.hasNext();) {
				OperationModel element = (OperationModel) iter.next();
				rv.addOperation(element);
			}
			unit.close();
			return rv;
		} catch (JavaModelException e) {
			e.printStackTrace();
		}
		return null;
	}

	private List getMethods(IType type){
		try{
			IMethod[] methods = type.getMethods();
			List result = new ArrayList();
			for(int i=0;i<methods.length;i++){
				OperationModel ope = new OperationModel();
				ope.setName(methods[i].getElementName());
				ope.setType(Signature.toString(methods[i].getReturnType()));
				if(Flags.isPublic(methods[i].getFlags())){
					ope.setVisibility(Visibility.PUBLIC);
				} else if(Flags.isPrivate(methods[i].getFlags())){
					ope.setVisibility(Visibility.PRIVATE);
				} else if(Flags.isProtected(methods[i].getFlags())){
					ope.setVisibility(Visibility.PROTECTED);
				} else {
					ope.setVisibility(Visibility.PACKAGE);
				}
				ope.setAbstract(Flags.isAbstract(methods[i].getFlags()));
				ope.setStatic(Flags.isStatic(methods[i].getFlags()));
				List params = new ArrayList();
				String[] names = methods[i].getParameterNames();
				String[] types = methods[i].getParameterTypes();
				for(int j=0;j<names.length;j++){
					Argument arg = new Argument();
					arg.setName(names[j]);
					arg.setType(Signature.toString(types[j]));
					params.add(arg);
				}
				ope.setParams(params);
				result.add(ope);
			}
			return result;
		} catch(Exception ex){
			ex.printStackTrace();
		}
		return Collections.EMPTY_LIST;
	}
	
	public Object getObjectType() {
		try {
			IType[] types = unit.getTypes();
			IType type = types[0];
			if (type.isInterface()) {
				return InterfaceModel.class;
			} else {
				return ClassModel.class;
			}
		} catch (Exception e) {
			// TODO: handle exception
		}
		return ClassModel.class;
	}

}