/**
 * 
 */
package net.java.amateras.uml.dnd.java;

import net.java.amateras.uml.model.EntityModel;
import net.java.amateras.uml.sequencediagram.model.InstanceModel;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;

/**
 * @author shida
 *
 */
public class InstanceModelConverter extends ClassModelConverter {

	private String name;
	public InstanceModelConverter(ICompilationUnit unit) {
		super(unit);
		try {
			this.name = this.unit.getTypes()[0].getElementName();
		} catch (JavaModelException e) {
			e.printStackTrace();
		}
	}

	public Object getNewObject() {
		EntityModel model = (EntityModel) super.getNewObject();
		model.setName(this.name);
		InstanceModel instance = new InstanceModel();
		instance.setType(model);
		return instance;
	}
	
	public Object getObjectType() {
		return InstanceModel.class;
	}
}
