/**
 * 
 */
package net.java.amateras.uml.dnd.java;

import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;

/**
 * @author shida
 *
 */
public class SequenceDropTargetListener extends
		AbstractTransferDropTargetListener {

	public SequenceDropTargetListener(EditPartViewer viewer, Transfer xfer) {
		super(viewer, xfer);
	}

	protected void handleDragOver() {
		getCurrentEvent().detail = DND.DROP_COPY;
		super.handleDragOver();
	}
	
	protected Request createTargetRequest() {
		CreateRequest request = new CreateRequest();
		return request;
	}

	protected ICompilationUnit getCompilationUnit(
			IStructuredSelection selection) {
		ICompilationUnit unit = null;
		Object firstElement = selection.getFirstElement();
		if (firstElement instanceof ICompilationUnit) {
			unit = (ICompilationUnit) firstElement;
		}
		return unit;
	}
	
	protected void updateTargetRequest() {
		((CreateRequest) getTargetRequest()).setLocation(getDropLocation());
	}
	protected void handleDrop() {
		ICompilationUnit unit = getCompilationUnit((IStructuredSelection) getCurrentEvent().data);
		((CreateRequest) getTargetRequest())
				.setFactory(new InstanceModelConverter(unit));
		super.handleDrop();
		getCurrentEvent().detail = DND.DROP_COPY;
	}
}
