package net.java.amateras.uml.java;

import java.util.ArrayList;
import java.util.List;

import net.java.amateras.uml.classdiagram.ClassDiagramEditor;
import net.java.amateras.uml.classdiagram.model.Argument;
import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.ClassModel;
import net.java.amateras.uml.classdiagram.model.InterfaceModel;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.classdiagram.model.Visibility;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.RootModel;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.IJavaElementSearchConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.SelectionDialog;

public class JavaImportAction implements IEditorActionDelegate {
	
	private ClassDiagramEditor editor;
	
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		this.editor = (ClassDiagramEditor)targetEditor;
	}

	public void run(IAction action) {
		IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
		IJavaProject project = JavaCore.create(input.getFile().getProject());
		
		Shell shell = editor.getSite().getShell();
		try {
			SelectionDialog dialog = JavaUI.createTypeDialog(
					shell,new ProgressMonitorDialog(shell),
					SearchEngine.createJavaSearchScope(new IJavaElement[]{project}),
					IJavaElementSearchConstants.CONSIDER_CLASSES|IJavaElementSearchConstants.CONSIDER_INTERFACES,
					false);
			
			if(dialog.open()==SelectionDialog.OK){
				Object[] result = dialog.getResult();
				IType type = (IType)result[0];
				RootModel root = (RootModel)this.editor.getAdapter(RootModel.class);
				CommandStack stack = (CommandStack)editor.getAdapter(CommandStack.class);
				stack.execute(new ImportClassCommand(root,type));
			}
		} catch(Exception ex){
			ex.printStackTrace();
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}
	
	private static class ImportClassCommand extends Command {
		
		private IType type;
		private RootModel root;
		private AbstractUMLEntityModel model;
		
		public ImportClassCommand(RootModel root,IType type){
			this.root = root;
			this.type = type;
		}
		
		public void execute(){
			try {
				if(this.type.isInterface()){
					InterfaceModel model = new InterfaceModel();
					model.setName(type.getFullyQualifiedName());
					model.setConstraint(new Rectangle(10,10,-1,-1));
					AttributeModel[] fields = getFields();
					for(int i=0;i<fields.length;i++){
						model.addAttribute(fields[i]);
					}
					OperationModel[] methods = getMethods();
					for(int i=0;i<methods.length;i++){
						model.addOperation(methods[i]);
					}
					this.model = model;
				} else if(this.type.isClass()){
					ClassModel model = new ClassModel();
					model.setName(type.getFullyQualifiedName());
					model.setConstraint(new Rectangle(10,10,-1,-1));
					AttributeModel[] attrs = getFields();
					for(int i=0;i<attrs.length;i++){
						model.addAttribute(attrs[i]);
					}
					OperationModel[] methods = getMethods();
					for(int i=0;i<methods.length;i++){
						model.addOperation(methods[i]);
					}
					this.model = model;
				}
				if(this.model != null){
					root.copyPresentation(this.model);
					root.addChild(this.model);
				}
			} catch(Exception ex){
				ex.printStackTrace();
			}
		}
		
		public void undo(){
			this.root.removeChild(this.model);
		}
		
		private AttributeModel[] getFields(){
			try {
				IField[] fields = type.getFields();
				AttributeModel[] result = new AttributeModel[fields.length];
				for(int i=0;i<fields.length;i++){
					AttributeModel attr = new AttributeModel();
					attr.setName(fields[i].getElementName());
					attr.setType(Signature.toString(fields[i].getTypeSignature()));
					attr.setStatic(Flags.isStatic(fields[i].getFlags()));
					if(Flags.isPublic(fields[i].getFlags())){
						attr.setVisibility(Visibility.PUBLIC);
					} else if(Flags.isPrivate(fields[i].getFlags())){
						attr.setVisibility(Visibility.PRIVATE);
					} else if(Flags.isProtected(fields[i].getFlags())){
						attr.setVisibility(Visibility.PROTECTED);
					} else {
						attr.setVisibility(Visibility.PACKAGE);
					}
					result[i] = attr;
				}
				return result;
			} catch(Exception ex){
				ex.printStackTrace();
			}
			return new AttributeModel[0];
		}
		
		private OperationModel[] getMethods(){
			try{
				IMethod[] methods = type.getMethods();
				OperationModel[] result = new OperationModel[methods.length];
				for(int i=0;i<methods.length;i++){
					OperationModel ope = new OperationModel();
					ope.setName(methods[i].getElementName());
					ope.setType(Signature.toString(methods[i].getReturnType()));
					if(Flags.isPublic(methods[i].getFlags())){
						ope.setVisibility(Visibility.PUBLIC);
					} else if(Flags.isPrivate(methods[i].getFlags())){
						ope.setVisibility(Visibility.PRIVATE);
					} else if(Flags.isProtected(methods[i].getFlags())){
						ope.setVisibility(Visibility.PROTECTED);
					} else {
						ope.setVisibility(Visibility.PACKAGE);
					}
					ope.setAbstract(Flags.isAbstract(methods[i].getFlags()));
					ope.setStatic(Flags.isStatic(methods[i].getFlags()));
					List params = new ArrayList();
					String[] names = methods[i].getParameterNames();
					String[] types = methods[i].getParameterTypes();
					for(int j=0;j<names.length;j++){
						Argument arg = new Argument();
						arg.setName(names[j]);
						arg.setType(Signature.toString(types[j]));
						params.add(arg);
					}
					ope.setParams(params);
					result[i] = ope;
				}
				return result;
			} catch(Exception ex){
				ex.printStackTrace();
			}
			return new OperationModel[0];
		}
		
//      change to use Sigunature.toString()		
//		private String convertTypeName(String value){
//			if(value.startsWith("L") && value.endsWith(";")){
//				return value.substring(1, value.length()-1);
//			}
//			if(value.startsWith("Q") && value.endsWith(";")){
//				return value.substring(1, value.length()-1);
//			}
//			if(value.equals("V")){
//				return "void";
//			}
//			if(value.equals("I")){
//				return "int";
//			}
//			if(value.equals("Z")){
//				return "boolean";
//			}
//			return value;
//		}
	}

}
