###############################################################################
#
# HTMLΥѡ
#
###############################################################################
package SNS::HTMLParser;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self  = {};
	return bless $self,$class;
}

#==============================================================================
# Ԥޤ
#==============================================================================
sub init {
	my $self = shift;
}

#==============================================================================
# ѡƥΥꥹȤ֤ޤ
#==============================================================================
sub parse {
	my $self   = shift;
	my $source = shift;
	my $words  = shift;
	my @lines  = split(/\n/,$source);
	
	my @sections;
	my $section   = 0;
	my $sec_title = "";
	my $sec_body  = "";
	my $start_tag = 0;
	my $count     = 0;
	
	foreach my $line (@lines){
		if($line eq ""){
			if($sec_title ne ""){
				if(Util::includes($sec_title,$words) || Util::includes($sec_body,$words)){
					push(@sections,{ID=>$count,TITLE=>$sec_title,CONTENT=>$sec_body});
				}
				$count++;
			}
			$section   = 0;
			$sec_title = "";
			$sec_body  = "";
			$start_tag = 0;
			
		} elsif($section == 0) {
			$sec_title = $line;
			$section   = 1;
			
		} else {
			if($line =~ /^\s*<\/{0,1}(ol|ul|li|pre|blockquote|h)/i){
				$sec_body .= "$line\n";
				if($start_tag==0){
					$start_tag = 1;
				} else {
					$start_tag = 0;
				}
			} elsif($start_tag==1){
				$sec_body .= "$line\n";
				
			} else {
				$sec_body .= "<p>$line</p>\n";
			}
		}
	}
	
	if($sec_title ne ""){
		if(Util::includes($sec_title,$words) || Util::includes($sec_body,$words)){
			push(@sections,{ID=>$count,TITLE=>$sec_title,CONTENT=>$sec_body});
		}
	}
	
	return @sections;
}

###############################################################################
#
# WikiΥѡ
#
###############################################################################
package SNS::WikiParser;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self  = {};
	return bless $self,$class;
}

#==============================================================================
# Ԥޤ
#==============================================================================
sub init {
	my $self = shift;
	
	$self->{pre}     = "";
	$self->{quote}   = "";
	$self->{table}   = 0;
	$self->{level}   = 0;
	$self->{para}    = 0;
	$self->{p_cnt}   = 0;
	$self->{dl_flag} = 0;
	$self->{dt}      = "";
	$self->{dd}      = "";
	$self->{sec_title} = "";
	$self->{sec_body}  = "";
}

#==============================================================================
# ѡƥΥꥹȤ֤ޤ
#==============================================================================
sub parse {
	my $self   = shift;
	my $source = shift;
	my $words  = shift;
	
	my @lines = split(/\n/,$source);
	my @sections;
	my $count = 0;
	
	foreach my $line (@lines){
		# ʣԤ
		$self->_multi_dl($line);
		
		my $word1 = substr($line,0,1);
		my $word2 = substr($line,0,2);
		my $word3 = substr($line,0,3);
		
		if($line ne "" && $self->{sec_title} eq ""){
			$self->{sec_title} = join("",$self->_parse_line($line));
			next;
		}
		
		# 
		if($line eq ""){
			$self->_line_paragraph();
			if($self->{sec_title} ne ""){
				if(Util::includes($self->{sec_title},$words) || Util::includes($self->{sec_body},$words)){
					push(@sections,{ID=>$count,TITLE=>$self->{sec_title},CONTENT=>$self->{sec_body}});
				}
				$self->{sec_title} = "";
				$self->{sec_body}  = "";
				$count++;
			}
			next;
		}
		
		# PRE
		if($word1 eq " " || $word1 eq "\t"){
			$self->_line_pre($line);
			
		# 
		} elsif($word3 eq "***"){
			my @obj = $self->_parse_line(substr($line,3));
			$self->_line_list(3,\@obj);
			
		} elsif($word2 eq "**"){
			my @obj = $self->_parse_line(substr($line,2));
			$self->_line_list(2,\@obj);
			
		} elsif($word1 eq "*"){
			my @obj = $self->_parse_line(substr($line,1));
			$self->_line_list(1,\@obj);
			
		# ֹդ
		} elsif($word3 eq "+++"){
			my @obj = $self->_parse_line(substr($line,3));
			$self->_line_numlist(3,\@obj);
			
		} elsif($word2 eq "++"){
			my @obj = $self->_parse_line(substr($line,2));
			$self->_line_numlist(2,\@obj);
			
		} elsif($word1 eq "+"){
			my @obj = $self->_parse_line(substr($line,1));
			$self->_line_numlist(1,\@obj);
			
		# ʿ
		} elsif($line eq "----"){
			$self->_line_hr();
		
		# 
		} elsif($word2 eq '""'){
			my @obj = $self->_parse_line(substr($line,2));
			$self->_line_quote(\@obj);
			
		# 
		} elsif(index($line,":")==0 && index($line,":",1)!=-1){
			if(index($line,":::")==0){
				$self->{dd} .= substr($line,3);
				next;
			}
			if(index($line,"::")==0){
				if($self->{dt} ne "" || $self->{dd} ne ""){
					$self->_multi_dl;
				}
				$self->{dt} = substr($line,2);
				$self->{dl_flag} = 1;
				next;
			}
			my $dt = substr($line,1,index($line,":",1)-1);
			my $dd = substr($line,index($line,":",1)+1);
			my @obj1 = $self->_parse_line($dt);
			my @obj2 = $self->_parse_line($dd);
			$self->_line_dl(\@obj1,\@obj2);
			
		# ơ֥
		} elsif($word1 eq ","){
			if($line =~ /,$/){
				$line .= " ";
			}
			my @spl = split(/,/,substr($line,1));
			my @array;
			foreach my $value (@spl){
				my @cell = $self->_parse_line($value);
				push @array,\@cell;
			}
			$self->_line_table(\@array);
			
		# ʤ
		} else {
			my @obj = $self->_parse_line($line);
			$self->_line_text(\@obj);
		}
	}
	
	# ʣԤ
	$self->_multi_dl;
	
	# ѡλ
	$self->_end_list;
	$self->_end_pre;
	$self->_end_table;
	$self->_end_quote;
	
	if($self->{para}==1){
		$self->{sec_body} .= "</p>";
		$self->{para} = 0;
	}
	
	if($self->{sec_title} ne ""){
		if(Util::includes($self->{sec_title},$words) || Util::includes($self->{sec_body},$words)){
			push(@sections,{ID=>$count,TITLE=>$self->{sec_title},CONTENT=>$self->{sec_body}});
		}
	}
	
	return @sections;
}

#===============================================================================
# ʣԤ
#===============================================================================
sub _multi_dl {
	my $self = shift;
	my $line = shift;
	if($self->{dl_flag}==1 && (index($line,":")!=0 || !defined($line))){
		my @obj1 = $self->_parse_line($self->{dt});
		my @obj2 = $self->_parse_line($self->{dd});
		$self->_line_dl(\@obj1,\@obj2);
		$self->{dl_flag} = 0;
		$self->{dt} = "";
		$self->{dd} = "";
	}
}

#==============================================================================
# ꥹ
#==============================================================================
sub _line_list {
	my $self  = shift;
	my $level = shift;
	my $obj   = shift;
	
	if($self->{para}==1){
		$self->{sec_body} .= "</p>";
		$self->{para} = 0;
	}
	
	$self->_end_pre;
	$self->_end_table;
	
	my $html = join("",@$obj);
	my $plus = 1;
	
	if($level < $self->{level}){ $plus = -1; }
	if($level==$self->{level}){
		$self->{sec_body} .= "</li>\n";
	}
	while($level != $self->{level}){
		if($plus==1){
			$self->{sec_body} .= "<ul>\n";
			push(@{$self->{close_list}},"</ul>");
		} else {
			$self->{sec_body} .= "</li>\n";
			$self->{sec_body} .= pop(@{$self->{close_list}});
		}
		$self->{level} += $plus;
	}
	
	$self->{sec_body} .= "<li>".$html."\n";
}

#==============================================================================
# ֹդꥹ
#==============================================================================
sub _line_numlist {
	my $self  = shift;
	my $level = shift;
	my $obj   = shift;
	
	if($self->{para}==1){
		$self->{sec_body} .= "</p>";
		$self->{para} = 0;
	}
	
	$self->_end_pre;
	$self->_end_table;
	
	my $html = join("",@$obj);
	my $plus = 1;
	
	if($level < $self->{level}){ $plus = -1; }
	if($level==$self->{level}){
		$self->{sec_body} .= "</li>\n";
	}
	while($level != $self->{level}){
		if($plus==1){
			$self->{sec_body} .= "<ol>\n";
			push(@{$self->{close_list}},"</ol>");
		} else {
			$self->{sec_body} .= "</li>\n";
			$self->{sec_body} .= pop(@{$self->{close_list}});
		}
		$self->{level} += $plus;
	}
	$self->{sec_body} .= "<li>".$html."\n";
}

#==============================================================================
# ꥹȤνλ
#==============================================================================
sub _end_list {
	my $self  = shift;
	if ($self->{level}!=0) {
		$self->{sec_body} .= "</li>\n";
		while($self->{level}!=0){
			$self->{sec_body} .= pop(@{$self->{close_list}});
			$self->{level} += -1;
		}
	}
}

#==============================================================================
# ʿ
#==============================================================================
sub _line_hr {
	my $self = shift;
	
	$self->_end_list;
	$self->_end_pre;
	$self->_end_table;
	$self->_end_quote;
	
	$self->{sec_body} .= "<hr>\n";
}

#==============================================================================
# ڤ
#==============================================================================
sub _line_paragraph {
	my $self = shift;
	
	$self->_end_list;
	$self->_end_pre;
	$self->_end_table;
	$self->_end_quote;
	
	if($self->{para}==1){
		$self->{sec_body} .= "</p>";
		$self->{para} = 0;
	}
}

#==============================================================================
# ѥƥ
#==============================================================================
sub _line_pre {
	my $self  = shift;
	my $text  = shift;
	
	if($self->{para}==1){
		$self->{sec_body} .= "</p>";
		$self->{para} = 0;
	}
	
	$self->_end_list;
	$self->_end_table;
	$self->_end_quote;
	
	$text =~ s/^\s//;
	$self->{pre} .= Util::escapeHTML($text)."\n";
}

sub _end_pre {
	my $self  = shift;
	if($self->{pre} ne ""){
		$self->{sec_body} .= "<pre>".$self->{pre}."</pre>";
		$self->{pre} = "";
	}
}

#==============================================================================
# ơ֥
#==============================================================================
sub _line_table {
	my $self = shift;
	my $row  = shift;
	$self->_end_list;
	$self->_end_pre;
	$self->_end_quote;
	
	if($self->{table}==0){
		$self->{table}=1;
		$self->{sec_body} .= "<table>\n";
		$self->{sec_body} .= "<tr>";
		foreach(@$row){
			my $html = join("",@$_);
			$self->{sec_body} .= "<th>".$html."</th>";
		}
		$self->{sec_body} .= "</tr>\n";
	} else {
		$self->{table}=2;
		$self->{sec_body} .= "<tr>";
		foreach(@$row){
			my $html = join("",@$_);
			$self->{sec_body} .= "<td>".$html."</td>";
		}
		$self->{sec_body} .= "</tr>\n";
	}
}

sub _end_table {
	my $self = shift;
	if($self->{table}!=0){
		$self->{table} = 0;
		$self->{sec_body} .= "</table>\n";
	}
}

#==============================================================================
# Խ񼰤˳ʤ
#==============================================================================
sub _line_text {
	my $self = shift;
	my $obj  = shift;
	$self->_end_list;
	$self->_end_pre;
	$self->_end_table;
	$self->_end_quote;
	my $html = join("",@$obj);
	
	if($self->{para}==0){
		$self->{sec_body} .= "<p>";
		$self->{para} = 1;
	}
	$self->{sec_body} .= $html;
	$self->_line_paragraph;
}

#==============================================================================
# 
#==============================================================================
sub _line_quote {
	my $self = shift;
	my $obj  = shift;
	$self->_end_list;
	$self->_end_pre;
	$self->_end_table;
	my $html = join("",@$obj);
	$self->{quote} .= "<p>".$html."</p>\n";
}

sub _end_quote {
	my $self = shift;
	if($self->{quote} ne ""){
		$self->{sec_body} .= "<blockquote>".$self->{quote}."</blockquote>\n";
		$self->{quote} = "";
	}
}

#==============================================================================
# 
#==============================================================================
sub _line_dl {
	my $self = shift;
	my $obj1 = shift;
	my $obj2 = shift;
	
	$self->_end_list;
	$self->_end_pre;
	$self->_end_table;
	$self->_end_quote;
	
	my $html1 = join("",@$obj1);
	my $html2 = join("",@$obj2);
	
	$self->{sec_body} .= "<dl>\n<dt>".$html1."</dt>\n<dd>".$html2."</dd>\n</dl>\n";
}

#===============================================================================
# ʬѡ
#===============================================================================
sub _parse_line {
	my $self   = shift;
	my $source = shift;
	my @array  = ();
	
	# ץ饰
	if($source =~ /({{)(.+?)(}})/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->_parse_line($pre)); }
		push @array,"<%=$label%>";
		if($post ne ""){ push(@array,$self->_parse_line($post)); }
		
	# Ǥä
	} elsif($source =~ /(==)(.+?)(==)/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->_parse_line($pre)); }
		push @array,"<del>".join("",$self->_parse_line($label))."</del>";
		if($post ne ""){ push(@array,$self->_parse_line($post)); }
		
	# ܡ
	} elsif($source =~ /(''')(.+?)(''')/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->_parse_line($pre)); }
		push @array,"<strong>".join("",$self->_parse_line($label))."</strong>";
		if($post ne ""){ push(@array,$self->_parse_line($post)); }
	
	# å
	} elsif($source =~ /('')(.+?)('')/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->_parse_line($pre)); }
		push @array,"<em>".join("",$self->_parse_line($label))."</em>";
		if($post ne ""){ push(@array,$self->_parse_line($post)); }
		
	# 
	} elsif($source =~ /(__)(.+?)(__)/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->_parse_line($pre)); }
		push @array,"<ins>".join("",$self->_parse_line($label))."</ins>";
		if($post ne ""){ push(@array,$self->_parse_line($post)); }

	# ̾
	} elsif($source =~ /\[([^\[]+?)\|((http|https|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]/
	    ||  $source =~ /\[([^\[]+?)\|(file:[^\[\]]*)\]/
	    ||  $source =~ /\[([^\[]+?)\|((\/|\.\/|\.\.\/)+[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]/){
		my $pre   = $`;
		my $post  = $';
		my $label = $1;
		my $url   = $2;
		if($pre ne ""){ push(@array,$self->_parse_line($pre)); }
		push @array,"<a href=\"$url\">".&Util::escapeHTML($label)."</a>";
		if($post ne ""){ push(@array,$self->_parse_line($post)); }
		
	# URL
	} elsif($source =~ /(http|https|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*/
	    ||  $source =~ /\[([^\[]+?)\|(file:[^\[\]]*)\]/){
		my $pre   = $`;
		my $post  = $';
		my $url = $&;
		if($pre ne ""){ push(@array,$self->_parse_line($pre)); }
		push @array,"<a href=\"$url\">".&Util::escapeHTML($url)."</a>";
		if($post ne ""){ push(@array,$self->_parse_line($post)); }
		
	} else {
		push @array,&Util::escapeHTML($source);
	}
	
	return @array;
}

1;
