/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.csseditor.editors;

import java.util.ArrayList;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import tk.eclipse.plugin.csseditor.editors.CSSDefinition;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;

public class CSSAssistProcessor
implements IContentAssistProcessor {
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String text = viewer.getDocument().get().substring(0, offset);
        String word = this.getLastWord(text);
        ArrayList<CompletionProposal> list = new ArrayList<CompletionProposal>();
        if (word != null) {
            int i = 0;
            while (i < CSSDefinition.CSS_KEYWORDS.length) {
                if (CSSDefinition.CSS_KEYWORDS[i].getReplaceString().startsWith(word)) {
                    list.add(new CompletionProposal(CSSDefinition.CSS_KEYWORDS[i].getReplaceString(), offset - word.length(), word.length(), CSSDefinition.CSS_KEYWORDS[i].getReplaceString().length(), HTMLPlugin.getDefault().getImageRegistry().get("_icon_css_prop"), CSSDefinition.CSS_KEYWORDS[i].getDisplayString(), null, null));
                }
                ++i;
            }
        }
        ICompletionProposal[] prop = list.toArray(new ICompletionProposal[list.size()]);
        HTMLUtil.sortCompilationProposal(prop);
        return prop;
    }

    private String getLastWord(String text) {
        text = HTMLUtil.cssComment2space(text);
        int index1 = text.lastIndexOf(59);
        int index2 = text.lastIndexOf(123);
        if (index1 >= 0 && index1 > index2) {
            return text.substring(index1 + 1).trim();
        }
        if (index2 >= 0) {
            return text.substring(index2 + 1).trim();
        }
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        ContextInformation[] info = new ContextInformation[]{};
        return info;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[0];
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public String getErrorMessage() {
        return "error";
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }
}

