/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.assist.CustomAttribute;
import tk.eclipse.plugin.htmleditor.assist.CustomElement;

public class CustomAssistPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer attributeTableViewer;
    private TableViewer elementTableViewer;
    private List elementModel = new ArrayList();
    private List attributeModel = new ArrayList();

    public CustomAssistPreferencePage() {
        super("CustomAssist");
        this.setPreferenceStore(HTMLPlugin.getDefault().getPreferenceStore());
        this.setDescription(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.CustomAssist.Desc"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem elementTab = new TabItem(tabFolder, 0);
        elementTab.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.CustomElements"));
        elementTab.setControl(this.createElementArea(tabFolder));
        TabItem attributeTab = new TabItem(tabFolder, 0);
        attributeTab.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.CustomAttributes"));
        attributeTab.setControl(this.createAttributeArea(tabFolder));
        this.performDefaults();
        return composite;
    }

    private Control createElementArea(TabFolder tabFolder) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.elementTableViewer = new TableViewer(composite, 68354);
        Table table = this.elementTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        this.elementTableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.elementTableViewer.setLabelProvider((IBaseLabelProvider)new CustomAssistLabelProvider());
        TableColumn col1 = new TableColumn(table, 0);
        col1.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.DisplayName"));
        col1.setWidth(100);
        TableColumn col2 = new TableColumn(table, 0);
        col2.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.AssistString"));
        col2.setWidth(200);
        Composite buttons = new Composite(composite, 0);
        buttons.setLayout((Layout)new GridLayout(1, true));
        buttons.setLayoutData((Object)new GridData(1040));
        this.elementTableViewer.setInput((Object)this.elementModel);
        Button add = new Button(buttons, 8);
        add.setText(HTMLPlugin.getResourceString("Button.Add"));
        add.setLayoutData((Object)CustomAssistPreferencePage.createButtonGridData());
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CustomElementDialog dialog = new CustomElementDialog(CustomAssistPreferencePage.this.getShell());
                if (dialog.open() == 0) {
                    CustomAssistPreferencePage.this.elementModel.add(dialog.getCustomElement());
                    CustomAssistPreferencePage.this.elementTableViewer.refresh();
                }
            }
        });
        final Button edit = new Button(buttons, 8);
        edit.setText(HTMLPlugin.getResourceString("Button.Edit"));
        edit.setLayoutData((Object)CustomAssistPreferencePage.createButtonGridData());
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IStructuredSelection sel = (IStructuredSelection)CustomAssistPreferencePage.this.elementTableViewer.getSelection();
                CustomElement element = (CustomElement)sel.getFirstElement();
                CustomElementDialog dialog = new CustomElementDialog(CustomAssistPreferencePage.this.getShell(), element);
                if (dialog.open() == 0) {
                    CustomElement newElement = dialog.getCustomElement();
                    element.setDisplayName(newElement.getDisplayName());
                    element.setAssistString(newElement.getAssistString());
                    CustomAssistPreferencePage.this.elementTableViewer.refresh();
                }
            }
        });
        edit.setEnabled(false);
        final Button remove = new Button(buttons, 8);
        remove.setText(HTMLPlugin.getResourceString("Button.Remove"));
        remove.setLayoutData((Object)CustomAssistPreferencePage.createButtonGridData());
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IStructuredSelection sel = (IStructuredSelection)CustomAssistPreferencePage.this.elementTableViewer.getSelection();
                CustomAssistPreferencePage.this.elementModel.removeAll(sel.toList());
                CustomAssistPreferencePage.this.elementTableViewer.refresh();
            }
        });
        remove.setEnabled(false);
        this.elementTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)CustomAssistPreferencePage.this.elementTableViewer.getSelection();
                if (sel == null || sel.getFirstElement() == null) {
                    edit.setEnabled(false);
                    remove.setEnabled(false);
                } else {
                    edit.setEnabled(true);
                    remove.setEnabled(true);
                }
            }
        });
        return composite;
    }

    private Control createAttributeArea(TabFolder tabFolder) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.attributeTableViewer = new TableViewer(composite, 68354);
        Table table = this.attributeTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        this.attributeTableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.attributeTableViewer.setLabelProvider((IBaseLabelProvider)new CustomAssistLabelProvider());
        TableColumn col1 = new TableColumn(table, 0);
        col1.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.TargetTag"));
        col1.setWidth(100);
        TableColumn col2 = new TableColumn(table, 0);
        col2.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.AttributeName"));
        col2.setWidth(200);
        Composite buttons = new Composite(composite, 0);
        buttons.setLayout((Layout)new GridLayout(1, true));
        buttons.setLayoutData((Object)new GridData(1040));
        this.attributeTableViewer.setInput((Object)this.attributeModel);
        Button add = new Button(buttons, 8);
        add.setText(HTMLPlugin.getResourceString("Button.Add"));
        add.setLayoutData((Object)CustomAssistPreferencePage.createButtonGridData());
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CustomAttributeDialog dialog = new CustomAttributeDialog(CustomAssistPreferencePage.this.getShell());
                if (dialog.open() == 0) {
                    CustomAssistPreferencePage.this.attributeModel.add(dialog.getCustomAttribute());
                    CustomAssistPreferencePage.this.attributeTableViewer.refresh();
                }
            }
        });
        final Button edit = new Button(buttons, 8);
        edit.setText(HTMLPlugin.getResourceString("Button.Edit"));
        edit.setLayoutData((Object)CustomAssistPreferencePage.createButtonGridData());
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IStructuredSelection sel = (IStructuredSelection)CustomAssistPreferencePage.this.attributeTableViewer.getSelection();
                CustomAttribute attrInfo = (CustomAttribute)sel.getFirstElement();
                CustomAttributeDialog dialog = new CustomAttributeDialog(CustomAssistPreferencePage.this.getShell(), attrInfo);
                if (dialog.open() == 0) {
                    CustomAttribute newAttrInfo = dialog.getCustomAttribute();
                    attrInfo.setTargetTag(newAttrInfo.getTargetTag());
                    attrInfo.setAttributeName(newAttrInfo.getAttributeName());
                    CustomAssistPreferencePage.this.attributeTableViewer.refresh();
                }
            }
        });
        edit.setEnabled(false);
        final Button remove = new Button(buttons, 8);
        remove.setText(HTMLPlugin.getResourceString("Button.Remove"));
        remove.setLayoutData((Object)CustomAssistPreferencePage.createButtonGridData());
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IStructuredSelection sel = (IStructuredSelection)CustomAssistPreferencePage.this.attributeTableViewer.getSelection();
                CustomAssistPreferencePage.this.attributeModel.removeAll(sel.toList());
                CustomAssistPreferencePage.this.attributeTableViewer.refresh();
            }
        });
        remove.setEnabled(false);
        this.attributeTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)CustomAssistPreferencePage.this.attributeTableViewer.getSelection();
                if (sel == null || sel.getFirstElement() == null) {
                    edit.setEnabled(false);
                    remove.setEnabled(false);
                } else {
                    edit.setEnabled(true);
                    remove.setEnabled(true);
                }
            }
        });
        return composite;
    }

    protected void performDefaults() {
        this.attributeModel.clear();
        this.attributeModel.addAll(CustomAttribute.loadFromPreference());
        this.attributeTableViewer.refresh();
        this.elementModel.clear();
        this.elementModel.addAll(CustomElement.loadFromPreference());
        this.elementTableViewer.refresh();
    }

    public boolean performOk() {
        CustomAttribute.saveToPreference(this.attributeModel);
        CustomElement.saveToPreference(this.elementModel);
        return true;
    }

    private static GridData createButtonGridData() {
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        return gd;
    }

    private class CustomAssistLabelProvider
    implements ITableLabelProvider {
        CustomAssistLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof CustomAttribute) {
                CustomAttribute attr = (CustomAttribute)element;
                if (columnIndex == 0) {
                    return attr.getTargetTag();
                }
                if (columnIndex == 1) {
                    return attr.getAttributeName();
                }
            } else if (element instanceof CustomElement) {
                CustomElement elem = (CustomElement)element;
                if (columnIndex == 0) {
                    return elem.getDisplayName();
                }
                if (columnIndex == 1) {
                    return elem.getAssistString();
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class CustomElementDialog
    extends Dialog {
        private Text displayName;
        private Text assistString;
        private CustomElement element;

        public CustomElementDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        public CustomElementDialog(Shell parentShell, CustomElement element) {
            super(parentShell);
            this.element = element;
        }

        protected Point getInitialSize() {
            Point size = super.getInitialSize();
            size.x = 300;
            return size;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.CustomElements"));
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            label.setText("Display Name:");
            this.displayName = new Text(composite, 2048);
            if (this.element != null) {
                this.displayName.setText(this.element.getDisplayName());
            }
            this.displayName.setLayoutData((Object)new GridData(768));
            label = new Label(composite, 0);
            label.setText("Assist String:");
            this.assistString = new Text(composite, 2048);
            this.assistString.setLayoutData((Object)new GridData(768));
            if (this.element != null) {
                this.assistString.setText(this.element.getAssistString());
            }
            return composite;
        }

        protected void okPressed() {
            if (this.displayName.getText().length() == 0) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("HTMLEditorPreferencePage.DisplayName")}));
                return;
            }
            if (this.assistString.getText().length() == 0) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("HTMLEditorPreferencePage.AssistString")}));
                return;
            }
            this.element = new CustomElement(this.displayName.getText(), this.assistString.getText());
            super.okPressed();
        }

        public CustomElement getCustomElement() {
            return this.element;
        }
    }

    private class CustomAttributeDialog
    extends Dialog {
        private Text target;
        private Text name;
        private CustomAttribute attrInfo;

        public CustomAttributeDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        public CustomAttributeDialog(Shell parentShell, CustomAttribute attrInfo) {
            super(parentShell);
            this.attrInfo = attrInfo;
        }

        protected Point getInitialSize() {
            Point size = super.getInitialSize();
            size.x = 300;
            return size;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.CustomAttributes"));
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            label.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Dialog.TargetTag"));
            this.target = new Text(composite, 2048);
            if (this.attrInfo != null) {
                this.target.setText(this.attrInfo.getTargetTag());
            } else {
                this.target.setText("*");
            }
            this.target.setLayoutData((Object)new GridData(768));
            label = new Label(composite, 0);
            label.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Dialog.AttributeName"));
            this.name = new Text(composite, 2048);
            this.name.setLayoutData((Object)new GridData(768));
            if (this.attrInfo != null) {
                this.name.setText(this.attrInfo.getAttributeName());
            }
            return composite;
        }

        protected void okPressed() {
            if (this.target.getText().length() == 0) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("HTMLEditorPreferencePage.TargetTag")}));
                return;
            }
            if (this.name.getText().length() == 0) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("HTMLEditorPreferencePage.AttributeName")}));
                return;
            }
            this.attrInfo = new CustomAttribute(this.target.getText(), this.name.getText());
            super.okPressed();
        }

        public CustomAttribute getCustomAttribute() {
            return this.attrInfo;
        }
    }
}

