/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class HTMLProjectParams {
    private String root = "/";
    private boolean useDTD = true;
    private boolean validateXML = true;
    private boolean validateHTML = true;
    private boolean validateJSP = true;
    private boolean validateDTD = true;
    private boolean validateJS = true;
    private boolean removeMarkers = false;
    public static final String P_ROOT = "root";
    public static final String P_USE_DTD = "useDTD";
    public static final String P_VALIDATE_XML = "validateXML";
    public static final String P_VALIDATE_HTML = "validateHTML";
    public static final String P_VALIDATE_JSP = "validateJSP";
    public static final String P_VALIDATE_DTD = "validateDTD";
    public static final String P_VALIDATE_JS = "validateJS";
    public static final String P_REMOVE_MARKERS = "removeMarkers";

    public HTMLProjectParams() {
    }

    public HTMLProjectParams(IProject project) throws Exception {
        this.load(project);
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String webAppRoot) {
        this.root = webAppRoot;
    }

    public void setUseDTD(boolean useDTD) {
        this.useDTD = useDTD;
    }

    public boolean getUseDTD() {
        return this.useDTD;
    }

    public void setValidateHTML(boolean validateHTML) {
        this.validateHTML = validateHTML;
    }

    public boolean getValidateHTML() {
        return this.validateHTML;
    }

    public void setValidateJSP(boolean validateJSP) {
        this.validateJSP = validateJSP;
    }

    public boolean getValidateJSP() {
        return this.validateJSP;
    }

    public void setValidateDTD(boolean validateDTD) {
        this.validateDTD = validateDTD;
    }

    public boolean getValidateDTD() {
        return this.validateDTD;
    }

    public void setValidateJavaScript(boolean validateJS) {
        this.validateJS = validateJS;
    }

    public boolean getValidateJavaScript() {
        return this.validateJS;
    }

    public void setValidateXML(boolean validateXML) {
        this.validateXML = validateXML;
    }

    public boolean getValidateXML() {
        return this.validateXML;
    }

    public void setRemoveMarkers(boolean removeMarkers) {
        this.removeMarkers = removeMarkers;
    }

    public boolean getRemoveMarkers() {
        return this.removeMarkers;
    }

    public void save(IProject project) throws Exception {
        IFile configFile = project.getFile(".amateras");
        Properties props = new Properties();
        props.put(P_ROOT, this.root);
        props.put(P_USE_DTD, String.valueOf(this.useDTD));
        props.put(P_VALIDATE_XML, String.valueOf(this.validateXML));
        props.put(P_VALIDATE_HTML, String.valueOf(this.validateHTML));
        props.put(P_VALIDATE_JSP, String.valueOf(this.validateJSP));
        props.put(P_VALIDATE_DTD, String.valueOf(this.validateDTD));
        props.put(P_VALIDATE_JS, String.valueOf(this.validateJS));
        props.put(P_REMOVE_MARKERS, String.valueOf(this.removeMarkers));
        File file = configFile.getLocation().makeAbsolute().toFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        props.store(new FileOutputStream(file), "EclipseHTMLEditor configuration file");
        project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
    }

    public void load(IProject project) throws Exception {
        IFile configFile = project.getFile(".amateras");
        String useDTD = null;
        String validateXML = null;
        String validateHTML = null;
        String validateJSP = null;
        String validateDTD = null;
        String validateJS = null;
        String removeMarkers = null;
        if (configFile.exists()) {
            File file = configFile.getLocation().makeAbsolute().toFile();
            Properties props = new Properties();
            props.load(new FileInputStream(file));
            this.root = props.getProperty(P_ROOT);
            useDTD = props.getProperty(P_USE_DTD);
            validateXML = props.getProperty(P_VALIDATE_XML);
            validateHTML = props.getProperty(P_VALIDATE_HTML);
            validateJSP = props.getProperty(P_VALIDATE_JSP);
            validateDTD = props.getProperty(P_VALIDATE_DTD);
            validateJS = props.getProperty(P_VALIDATE_JS);
            removeMarkers = props.getProperty(P_REMOVE_MARKERS);
        } else {
            this.root = project.getPersistentProperty(new QualifiedName(HTMLPlugin.getDefault().getPluginId(), P_ROOT));
            useDTD = project.getPersistentProperty(new QualifiedName(HTMLPlugin.getDefault().getPluginId(), P_USE_DTD));
            validateHTML = project.getPersistentProperty(new QualifiedName(HTMLPlugin.getDefault().getPluginId(), P_VALIDATE_HTML));
        }
        if (this.root == null) {
            this.root = "/";
        }
        this.useDTD = this.getBooleanValue(useDTD, true);
        this.validateXML = this.getBooleanValue(validateXML, true);
        this.validateHTML = this.getBooleanValue(validateHTML, true);
        this.validateJSP = this.getBooleanValue(validateJSP, true);
        this.validateDTD = this.getBooleanValue(validateDTD, true);
        this.validateJS = this.getBooleanValue(validateJS, true);
        this.removeMarkers = this.getBooleanValue(removeMarkers, false);
    }

    private boolean getBooleanValue(String value, boolean defaultValue) {
        if (value != null) {
            if (value.equals("true")) {
                return true;
            }
            if (value.equals("false")) {
                return false;
            }
        }
        return defaultValue;
    }
}

