/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;

public class HTMLProjectPropertyPage
extends PropertyPage {
    private Text textWebAppRoot;
    private TableItem checkValidateXML;
    private TableItem checkValidateHTML;
    private TableItem checkValidateJSP;
    private TableItem checkValidateDTD;
    private TableItem checkValidateJS;
    private Button checkUseDTD;
    private Button checkRemoveMarkers;
    private HTMLProjectParams params;
    private Table table;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.addControls(composite);
        try {
            this.params = new HTMLProjectParams(this.getProject());
            this.fillControls();
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
        return composite;
    }

    private void addControls(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Composite panel = new Composite(composite, 0);
        panel.setLayoutData((Object)new GridData(768));
        panel.setLayout((Layout)new GridLayout(3, false));
        Label labelWebAppRoot = new Label(panel, 0);
        labelWebAppRoot.setText(HTMLPlugin.getResourceString("HTMLProjectPropertyPage.Root"));
        this.textWebAppRoot = new Text(panel, 2052);
        this.textWebAppRoot.setLayoutData((Object)new GridData(768));
        Button button = new Button(panel, 524288);
        button.setText("...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HTMLProjectPropertyPage.this.selectFolder();
            }
        });
        this.checkUseDTD = new Button(composite, 32);
        this.checkUseDTD.setText(HTMLPlugin.getResourceString("HTMLProjectPropertyPage.UseDTD"));
        new Label(composite, 0);
        Group group = new Group(composite, 0);
        group.setText(HTMLPlugin.getResourceString("HTMLProjectPropertyPage.Validation"));
        group.setLayoutData((Object)new GridData(1808));
        group.setLayout((Layout)new GridLayout(1, false));
        this.table = new Table((Composite)group, 2080);
        this.table.setLayoutData((Object)new GridData(1808));
        this.checkValidateHTML = new TableItem(this.table, 0);
        this.checkValidateHTML.setText(HTMLPlugin.getResourceString("HTMLProjectPropertyPage.ValidateHTML"));
        this.checkValidateJSP = new TableItem(this.table, 0);
        this.checkValidateJSP.setText(HTMLPlugin.getResourceString("HTMLProjectPropertyPage.ValidateJSP"));
        this.checkValidateXML = new TableItem(this.table, 0);
        this.checkValidateXML.setText(HTMLPlugin.getResourceString("HTMLProjectPropertyPage.ValidateXML"));
        this.checkValidateDTD = new TableItem(this.table, 0);
        this.checkValidateDTD.setText(HTMLPlugin.getResourceString("HTMLProjectPropertyPage.ValidateDTD"));
        this.checkValidateJS = new TableItem(this.table, 0);
        this.checkValidateJS.setText(HTMLPlugin.getResourceString("HTMLProjectPropertyPage.ValidateJS"));
        this.checkRemoveMarkers = new Button((Composite)group, 32);
        this.checkRemoveMarkers.setText(HTMLPlugin.getResourceString("HTMLProjectPropertyPage.RemoveMarkers"));
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    private void fillControls() {
        this.textWebAppRoot.setText(this.params.getRoot());
        this.checkUseDTD.setSelection(this.params.getUseDTD());
        this.checkValidateHTML.setChecked(this.params.getValidateHTML());
        this.checkValidateJSP.setChecked(this.params.getValidateJSP());
        this.checkValidateXML.setChecked(this.params.getValidateXML());
        this.checkValidateDTD.setChecked(this.params.getValidateDTD());
        this.checkValidateJS.setChecked(this.params.getValidateJavaScript());
        this.checkRemoveMarkers.setSelection(this.params.getRemoveMarkers());
    }

    protected void performDefaults() {
        this.params = new HTMLProjectParams();
        this.fillControls();
    }

    public boolean performOk() {
        this.params = new HTMLProjectParams();
        this.params.setRoot(this.textWebAppRoot.getText());
        this.params.setUseDTD(this.checkUseDTD.getSelection());
        this.params.setValidateHTML(this.checkValidateHTML.getChecked());
        this.params.setValidateJSP(this.checkValidateJSP.getChecked());
        this.params.setValidateXML(this.checkValidateXML.getChecked());
        this.params.setValidateDTD(this.checkValidateDTD.getChecked());
        this.params.setValidateJavaScript(this.checkValidateJS.getChecked());
        this.params.setRemoveMarkers(this.checkRemoveMarkers.getSelection());
        try {
            this.params.save(this.getProject());
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
            return false;
        }
        return true;
    }

    private void selectFolder() {
        try {
            IProject currProject = this.getProject();
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            IResource init = null;
            if (this.params.getRoot() != null) {
                init = wsroot.findMember(String.valueOf(currProject.getName()) + this.params.getRoot());
            }
            Class[] classArray = new Class[2];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Class[] acceptedClasses = classArray;
            TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
            IProject[] allProjects = wsroot.getProjects();
            ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
            int i = 0;
            while (i < allProjects.length) {
                if (!allProjects[i].equals((Object)currProject)) {
                    rejectedElements.add(allProjects[i]);
                }
                ++i;
            }
            TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
            FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle(HTMLPlugin.getResourceString("HTMLProjectPropertyPage.WebRoot"));
            dialog.setMessage(HTMLPlugin.getResourceString("HTMLProjectPropertyPage.WebRoot"));
            dialog.setInput((Object)wsroot);
            dialog.setValidator((ISelectionStatusValidator)validator);
            dialog.addFilter((ViewerFilter)filter);
            dialog.setInitialSelection((Object)init);
            if (dialog.open() == 0) {
                this.textWebAppRoot.setText(this.getFolderName(dialog.getFirstResult()));
            }
        }
        catch (Throwable t) {
            HTMLPlugin.openAlertDialog(t.toString());
        }
    }

    private IProject getProject() {
        return (IProject)this.getElement();
    }

    private String getFolderName(Object result) throws CoreException {
        if (result instanceof IFolder) {
            IFolder folder = (IFolder)result;
            String folderName = folder.getLocation().toString();
            String projectPath = this.getProject().getLocation().toString();
            if (folderName.length() <= projectPath.length()) {
                return folderName;
            }
            return folderName.substring(projectPath.length());
        }
        return "/";
    }
}

