/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.HTMLEditor;
import tk.eclipse.plugin.htmleditor.editors.HTMLEditorPart;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;

public class SplitPageHTMLEditor
extends EditorPart
implements IResourceChangeListener,
HTMLEditorPart {
    private HTMLSourceEditor editor;
    private Browser browser;
    private HTMLEditor wrapper;
    private boolean isHorizontal;
    private SplitEditorSite site;

    public SplitPageHTMLEditor(HTMLEditor wrapper, boolean isHorizontal, HTMLSourceEditor editor) {
        this.wrapper = wrapper;
        this.isHorizontal = isHorizontal;
        this.editor = editor;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public HTMLSourceEditor getSourceEditor() {
        return this.editor;
    }

    public void doSave(IProgressMonitor monitor) {
        this.editor.doSave(monitor);
        this.wrapper.updatePreview();
    }

    public void doSaveAs() {
        this.editor.doSaveAs();
        this.setInput(this.editor.getEditorInput());
        this.setPartName(this.getEditorInput().getName());
        this.wrapper.updatePreview();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
        this.setPartName(editorInput.getName());
    }

    public boolean isDirty() {
        if (this.editor != null) {
            return this.editor.isDirty();
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.site.dispose();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        try {
            if (!(this.getEditorInput() instanceof IFileEditorInput)) {
                this.editor.init(this.getEditorSite(), this.getEditorInput());
                this.editor.addPropertyListener(new IPropertyListener(){

                    public void propertyChanged(Object source, int propertyId) {
                        SplitPageHTMLEditor.this.firePropertyChange(propertyId);
                    }
                });
                this.editor.createPartControl(parent);
                return;
            }
            SashForm sash = null;
            sash = this.isHorizontal ? new SashForm(parent, 512) : new SashForm(parent, 256);
            this.site = new SplitEditorSite(this.editor, this.getEditorSite());
            this.editor.init(this.site, this.getEditorInput());
            this.editor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propertyId) {
                    SplitPageHTMLEditor.this.firePropertyChange(propertyId);
                }
            });
            this.editor.createPartControl((Composite)sash);
            this.browser = new Browser((Composite)sash, 0);
            this.wrapper.updatePreview();
        }
        catch (PartInitException e) {
            HTMLPlugin.logException(e);
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    public void gotoMarker(IMarker marker) {
        IDE.gotoMarker((IEditorPart)this.editor, (IMarker)marker);
    }

    public void setOffset(int offset) {
        this.editor.selectAndReveal(offset, 0);
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = SplitPageHTMLEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)SplitPageHTMLEditor.this.editor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(SplitPageHTMLEditor.this.editor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public boolean isFileEditorInput() {
        return this.editor.isFileEditorInput();
    }

    public Object getAdapter(Class adapter) {
        return this.editor.getAdapter(adapter);
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
        this.wrapper.firePropertyChange2(propertyId);
    }

    private static class SplitEditorSite
    implements IEditorSite {
        private HTMLSourceEditor editor;
        private IEditorSite site;
        private ArrayList menuExtenders;

        public SplitEditorSite(HTMLSourceEditor editor, IEditorSite site) {
            this.editor = editor;
            this.site = site;
        }

        public IEditorActionBarContributor getActionBarContributor() {
            return this.site.getActionBarContributor();
        }

        public IActionBars getActionBars() {
            return this.site.getActionBars();
        }

        public String getId() {
            return this.site.getId();
        }

        public IKeyBindingService getKeyBindingService() {
            return this.site.getKeyBindingService();
        }

        public String getPluginId() {
            return this.site.getPluginId();
        }

        public String getRegisteredName() {
            return this.site.getRegisteredName();
        }

        public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
            this.site.registerContextMenu(menuManager, selectionProvider);
        }

        public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
            if (this.menuExtenders == null) {
                this.menuExtenders = new ArrayList(1);
            }
            this.menuExtenders.add(new PopupMenuExtender(menuId, menuManager, selectionProvider, (IWorkbenchPart)this.editor));
        }

        public IWorkbenchPage getPage() {
            return this.site.getPage();
        }

        public ISelectionProvider getSelectionProvider() {
            return this.site.getSelectionProvider();
        }

        public Shell getShell() {
            return this.site.getShell();
        }

        public IWorkbenchWindow getWorkbenchWindow() {
            return this.site.getWorkbenchWindow();
        }

        public void setSelectionProvider(ISelectionProvider provider) {
            this.site.setSelectionProvider(provider);
        }

        public Object getAdapter(Class adapter) {
            return this.site.getAdapter(adapter);
        }

        public void dispose() {
            if (this.menuExtenders != null) {
                int i = 0;
                while (i < this.menuExtenders.size()) {
                    ((PopupMenuExtender)this.menuExtenders.get(i)).dispose();
                    ++i;
                }
                this.menuExtenders = null;
            }
        }

        public IWorkbenchPart getPart() {
            return this.editor;
        }

        public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
            this.registerContextMenu(menuManager, selectionProvider);
        }

        public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
            this.registerContextMenu(menuId, menuManager, selectionProvider);
        }

        public Object getService(Class api) {
            return null;
        }

        public boolean hasService(Class api) {
            return false;
        }
    }
}

