/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tk.eclipse.plugin.jseditor.editors.JavaScriptContext;
import tk.eclipse.plugin.jseditor.editors.JavaScriptElement;
import tk.eclipse.plugin.jseditor.editors.JavaScriptFunction;
import tk.eclipse.plugin.jseditor.editors.JavaScriptVariable;

public class JavaScriptModel
implements JavaScriptContext {
    private List children = new ArrayList();
    private JavaScriptContext context;
    private int endOffset;

    public JavaScriptModel(String source) {
        this.update(source);
    }

    public int getStartOffset() {
        return 0;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public JavaScriptContext getContextFromOffset(int offset) {
        return this.getContextFromOffset(this, offset);
    }

    private JavaScriptContext getContextFromOffset(JavaScriptContext context, int offset) {
        if (context.getStartOffset() < offset && context.getEndOffset() > offset) {
            JavaScriptElement[] children = context.getChildren();
            int i = 0;
            while (i < children.length) {
                JavaScriptContext result;
                if (children[i] instanceof JavaScriptContext && (result = this.getContextFromOffset((JavaScriptContext)((Object)children[i]), offset)) != null) {
                    return result;
                }
                ++i;
            }
            return context;
        }
        return null;
    }

    public void update(String source) {
        this.children.clear();
        this.endOffset = source.length();
        this.context = this;
        boolean whitespace = true;
        char quote = '\u0000';
        boolean escape = false;
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (c == '\"' || c == '\'') {
                if (!escape) {
                    quote = quote == c ? (char)'\u0000' : c;
                }
                escape = false;
            } else if (quote != '\u0000') {
                escape = c == '\\';
            } else {
                int result;
                if (c == '/' && source.length() < i + 1) {
                    char nc = source.charAt(i + 1);
                    if (nc == '/') {
                        while (nc != '\r' && nc != '\n' && source.length() < i) {
                            nc = source.charAt(++i + 1);
                        }
                    }
                    if (nc == '*' && (i = source.indexOf("*/", i)) == -1) break;
                }
                if (whitespace && c == 'v' && (result = JavaScriptModel.parseVariable(source, i, this.context)) != 0) {
                    whitespace = true;
                    i += result;
                } else if (whitespace && c == 'f' && (result = JavaScriptModel.parseFunction(source, i, this.context)) != null) {
                    whitespace = true;
                    i += ((Integer)result[0]).intValue();
                    this.context = (JavaScriptFunction)result[1];
                } else {
                    if (c == '}' && this.context.getParent() != null) {
                        if (this.context instanceof JavaScriptFunction) {
                            ((JavaScriptFunction)this.context).setEndOffset(i);
                        }
                        this.context = this.context.getParent();
                    }
                    whitespace = c == ' ' || c == '\t' || c == '\r' || c == '\n';
                }
            }
            ++i;
        }
    }

    private static int parseVariable(String source, int position, JavaScriptContext context) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("var[\\s\r\n]+(.+?)[\\s\r\n]*?[;=]");
        if (source.indexOf("var", position) == position && (matcher = pattern.matcher(source.substring(position))).find() && matcher.start() == 0) {
            JavaScriptVariable var = new JavaScriptVariable(matcher.group(1), position);
            context.add(var);
            return matcher.end();
        }
        return 0;
    }

    private static Object[] parseFunction(String source, int position, JavaScriptContext context) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("function[\\s\r\n]+?(.+?)[\\s\r\n]*?\\((.*?)\\)[\\s\r\n]*?\\{", 32);
        if (source.indexOf("function", position) == position && (matcher = pattern.matcher(source.substring(position))).find() && matcher.start() == 0) {
            String args = matcher.group(2).replaceAll("[\\s\r\n]*,[\\s\r\n]*", ", ").trim();
            JavaScriptFunction func = new JavaScriptFunction(matcher.group(1), args, position);
            func.setParent(context);
            context.add(func);
            return new Object[]{new Integer(matcher.end()), func};
        }
        return null;
    }

    public void add(JavaScriptFunction func) {
        this.children.add(func);
    }

    public void add(JavaScriptVariable var) {
        this.children.add(var);
    }

    public JavaScriptElement[] getChildren() {
        return this.children.toArray(new JavaScriptElement[this.children.size()]);
    }

    public JavaScriptElement[] getVisibleElements() {
        return this.getChildren();
    }

    public JavaScriptContext getParent() {
        return null;
    }
}

