/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.util.ArrayList;
import org.eclipse.jdt.internal.ui.text.JavaWhitespaceDetector;
import org.eclipse.jdt.internal.ui.text.JavaWordDetector;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import tk.eclipse.plugin.htmleditor.ColorProvider;

public class JSPScriptletScanner
extends RuleBasedScanner {
    private static String[] KEYWORDS = new String[]{"abstract", "break", "case", "catch", "class", "const", "continue", "default", "do", "else", "extends", "final", "finally", "for", "goto", "if", "implements", "import", "instanceof", "interface", "native", "new", "package", "private", "protected", "public", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "volatile", "while", "void", "boolean", "char", "byte", "short", "strictfp", "int", "long", "float", "double", "return", "true", "false"};

    public JSPScriptletScanner(ColorProvider provider) {
        IToken normal = provider.getToken("__pref_color_foreground");
        IToken comment = provider.getToken("__pref_jsp_comment");
        IToken string = provider.getToken("__pref_jsp_string");
        IToken keyword = provider.getToken("__pref_jsp_keyword");
        IToken script = provider.getToken("_pref_color_scriptlet");
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new MultiLineRule("/*", "*/", comment));
        rules.add(new EndOfLineRule("//", comment));
        rules.add(new SingleLineRule("\"", "\"", string, '\\'));
        rules.add(new SingleLineRule("'", "'", string, '\\'));
        WordRule wordRule = new WordRule((IWordDetector)new JavaWordDetector(), normal);
        int i = 0;
        while (i < KEYWORDS.length) {
            wordRule.addWord(KEYWORDS[i], keyword);
            ++i;
        }
        rules.add(wordRule);
        WordRule delimitor = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return c == '<' || c == '%';
            }

            public boolean isWordPart(char c) {
                return c == '<' || c == '%' || c == '=' || c == '>';
            }
        }, normal);
        delimitor.addWord("<%=", script);
        delimitor.addWord("<%", script);
        delimitor.addWord("%>", script);
        rules.add(delimitor);
        rules.add(new WhitespaceRule((IWhitespaceDetector)new JavaWhitespaceDetector()));
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }
}

