/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.IHyperlinkProvider;
import tk.eclipse.plugin.htmleditor.editors.HTMLConfiguration;
import tk.eclipse.plugin.htmleditor.editors.HTMLHyperlinkSupport;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;
import tk.eclipse.plugin.jspeditor.editors.JSPHyperlinkProvider;
import tk.eclipse.plugin.jspeditor.editors.JSPOutlinePage;
import tk.eclipse.plugin.jspeditor.editors.JSPValidator;

public class JSPSourceEditor
extends HTMLSourceEditor {
    public static final String ACTION_JSP_COMMENT = "_jsp_comment";

    public JSPSourceEditor(HTMLConfiguration config) {
        super(config);
        this.setAction(ACTION_JSP_COMMENT, (IAction)new JSPCommentAction());
    }

    protected void doValidate() {
        try {
            String[] natureIds = HTMLPlugin.getDefault().getNoValidationNatureId();
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            int i = 0;
            while (i < natureIds.length) {
                if (file.getProject().hasNature(natureIds[i])) {
                    return;
                }
                ++i;
            }
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        IFileEditorInput input = (IFileEditorInput)JSPSourceEditor.this.getEditorInput();
                        IFile file = input.getFile();
                        file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                        HTMLProjectParams params = new HTMLProjectParams(file.getProject());
                        if (params.getValidateJSP()) {
                            new JSPValidator(input.getFile()).doValidate();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    protected IHTMLOutlinePage createOutlinePage() {
        return new JSPOutlinePage(this);
    }

    protected HTMLHyperlinkSupport createHyperlinkSupport() {
        HTMLHyperlinkSupport hyperlink = super.createHyperlinkSupport();
        hyperlink.addHyperlinkProvider(new JSPHyperlinkProvider());
        IHyperlinkProvider[] providers = HTMLPlugin.getDefault().getHyperlinkProviders();
        int i = 0;
        while (i < providers.length) {
            hyperlink.addHyperlinkProvider(providers[i]);
            ++i;
        }
        return hyperlink;
    }

    protected void addContextMenuActions(IMenuManager menu) {
        super.addContextMenuActions(menu);
        this.addAction(menu, "_html", ACTION_JSP_COMMENT);
    }

    protected void updateSelectionDependentActions() {
        super.updateSelectionDependentActions();
        ITextSelection sel = (ITextSelection)this.getSelectionProvider().getSelection();
        if (sel.getText().equals("")) {
            this.getAction(ACTION_JSP_COMMENT).setEnabled(false);
        } else {
            this.getAction(ACTION_JSP_COMMENT).setEnabled(true);
        }
    }

    private class JSPCommentAction
    extends Action {
        public JSPCommentAction() {
            super(HTMLPlugin.getResourceString("HTMLEditor.JSPCommentAction"));
            this.setEnabled(false);
            this.setAccelerator(327727);
        }

        public void run() {
            ITextSelection sel = (ITextSelection)JSPSourceEditor.this.getSelectionProvider().getSelection();
            IDocument doc = JSPSourceEditor.this.getDocumentProvider().getDocument((Object)JSPSourceEditor.this.getEditorInput());
            String text = sel.getText().trim();
            try {
                if (text.startsWith("<%--") && text.endsWith("--%>")) {
                    text = sel.getText().replaceAll("<%--|--%>", "");
                    doc.replace(sel.getOffset(), sel.getLength(), text);
                } else {
                    doc.replace(sel.getOffset(), sel.getLength(), "<%--" + sel.getText() + "--%>");
                }
            }
            catch (BadLocationException e) {
                HTMLPlugin.logException(e);
            }
        }
    }
}

