/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.csseditor.editors;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import tk.eclipse.plugin.csseditor.editors.CSSCharacterPairMatcher;
import tk.eclipse.plugin.csseditor.editors.CSSConfiguration;
import tk.eclipse.plugin.csseditor.editors.CSSFileDocumentProvider;
import tk.eclipse.plugin.csseditor.editors.CSSOutlinePage;
import tk.eclipse.plugin.csseditor.editors.CSSTextDocumentProvider;
import tk.eclipse.plugin.csseditor.editors.ChooseColorAction;
import tk.eclipse.plugin.htmleditor.ColorProvider;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.FoldingInfo;
import tk.eclipse.plugin.htmleditor.editors.SoftTabVerifyListener;

public class CSSEditor
extends TextEditor {
    private ColorProvider colorProvider = HTMLPlugin.getDefault().getColorProvider();
    private CSSOutlinePage outline;
    private CSSCharacterPairMatcher pairMatcher;
    private SoftTabVerifyListener softTabListener;
    private ProjectionSupport fProjectionSupport;
    public static final String GROUP_CSS = "_css";
    public static final String ACTION_CHOOSE_COLOR = "_choose_color";
    private static final int FOLDING_NONE = 0;
    private static final int FOLDING_STYLE = 1;
    private static final int FOLDING_COMMENT = 2;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CSSEditor() {
        this.setSourceViewerConfiguration(new CSSConfiguration(this.colorProvider));
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), HTMLPlugin.getDefault().getPreferenceStore()}));
        this.outline = new CSSOutlinePage(this);
        this.setAction(ACTION_CHOOSE_COLOR, (IAction)new ChooseColorAction(this));
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        this.softTabListener = new SoftTabVerifyListener();
        this.softTabListener.setUseSoftTab(store.getBoolean("_pref_use_softtab"));
        this.softTabListener.setSoftTabWidth(store.getInt("_pref_softtab_width"));
    }

    protected final void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.add((IContributionItem)new Separator(GROUP_CSS));
        this.addAction(menu, GROUP_CSS, ACTION_CHOOSE_COLOR);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            this.setDocumentProvider((IDocumentProvider)new CSSTextDocumentProvider());
        } else if (input instanceof IStorageEditorInput) {
            this.setDocumentProvider((IDocumentProvider)new CSSFileDocumentProvider());
        } else {
            this.setDocumentProvider((IDocumentProvider)new CSSTextDocumentProvider());
        }
        super.doSetInput(input);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.outline.update();
        this.updateFolding();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.fOverviewRuler, true, styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        viewer.getTextWidget().addVerifyListener((VerifyListener)this.softTabListener);
        return viewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.install();
        viewer.doOperation(19);
        this.updateFolding();
        StyledText widget = viewer.getTextWidget();
        widget.setTabs(this.getPreferenceStore().getInt("tabWidth"));
        widget.addVerifyListener((VerifyListener)new SoftTabVerifyListener());
        ITextViewerExtension2 extension = (ITextViewerExtension2)this.getSourceViewer();
        this.pairMatcher = new CSSCharacterPairMatcher();
        this.pairMatcher.setEnable(this.getPreferenceStore().getBoolean("__pref_pair_character"));
        MatchingCharacterPainter painter = new MatchingCharacterPainter(this.getSourceViewer(), (ICharacterPairMatcher)this.pairMatcher);
        painter.setColor(Display.getDefault().getSystemColor(15));
        extension.addPainter((IPainter)painter);
    }

    public void dispose() {
        this.pairMatcher.dispose();
        this.fProjectionSupport.dispose();
        super.dispose();
    }

    public void doSaveAs() {
        super.doSaveAs();
        this.outline.update();
        this.updateFolding();
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return super.affectsTextPresentation(event) || this.colorProvider.affectsTextPresentation(event);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        this.colorProvider.handlePreferenceStoreChanged(event);
        String key = event.getProperty();
        if (key.equals("__pref_pair_character")) {
            boolean enable = (Boolean)event.getNewValue();
            this.pairMatcher.setEnable(enable);
        }
        super.handlePreferenceStoreChanged(event);
        this.softTabListener.preferenceChanged(event);
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(HTMLPlugin.getDefault().getResourceBundle(), "ContentAssistProposal", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
    }

    public Object getAdapter(Class adapter) {
        Object obj;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.outline;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter) && this.fProjectionSupport != null && (obj = this.fProjectionSupport.getAdapter(this.getSourceViewer(), adapter)) != null) {
            return obj;
        }
        return super.getAdapter(adapter);
    }

    private void updateFolding() {
        try {
            ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
            if (viewer == null) {
                return;
            }
            ProjectionAnnotationModel model = viewer.getProjectionAnnotationModel();
            if (model == null) {
                return;
            }
            ArrayList<FoldingInfo> list = new ArrayList<FoldingInfo>();
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            String source = doc.get();
            int type = 0;
            int start = -1;
            int startBackup = -1;
            int i = 0;
            while (i < source.length()) {
                char c = source.charAt(i);
                if (c == '/' && type != 2 && source.length() > i + 1) {
                    if (source.charAt(i + 1) == '*') {
                        if (type == 1) {
                            startBackup = start;
                        }
                        type = 2;
                        start = i++;
                    }
                } else if (c == '*' && type == 2 && source.length() > i + 1) {
                    if (source.charAt(i + 1) == '/') {
                        if (doc.getLineOfOffset(start) != doc.getLineOfOffset(i)) {
                            list.add(new FoldingInfo(start, i + 2 + FoldingInfo.countUpLineDelimiter(source, i + 2)));
                        }
                        if (startBackup != -1) {
                            type = 1;
                            start = startBackup;
                        } else {
                            type = 0;
                        }
                        startBackup = -1;
                        ++i;
                    }
                } else if (c == '{' && type == 0) {
                    if (type == 2) {
                        startBackup = start;
                    }
                    start = i;
                    type = 1;
                } else if (type == 1 && c == '}') {
                    if (doc.getLineOfOffset(start) != doc.getLineOfOffset(i)) {
                        list.add(new FoldingInfo(start, i + 1 + FoldingInfo.countUpLineDelimiter(source, i + 1)));
                    }
                    if (startBackup != -1) {
                        type = 2;
                        start = startBackup;
                    }
                    startBackup = -1;
                    type = 0;
                }
                ++i;
            }
            FoldingInfo.applyModifiedAnnotations(model, list);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }
}

