/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.dtdeditor.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import tk.eclipse.plugin.dtdeditor.editors.DTDEditor;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;

public class DTDOutlinePage
extends ContentOutlinePage
implements IHTMLOutlinePage {
    private DTDEditor editor;
    private DTDRootNode root;

    public DTDOutlinePage(DTDEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        if (this.root == null) {
            this.root = new DTDRootNode();
        }
        viewer.setContentProvider((IContentProvider)new DTDContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DTDLabelProvider());
        viewer.setInput((Object)this.root);
        viewer.addSelectionChangedListener((ISelectionChangedListener)new DTDSelectionChangedListener());
        this.update();
    }

    public void update() {
        String source = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get();
        source = FuzzyXMLUtil.comment2space((String)source, (boolean)true);
        if (this.root == null) {
            this.root = new DTDRootNode();
        }
        this.root.clear();
        int index = 0;
        int last = 0;
        HashMap<String, ArrayList<DTDNode>> attrMap = new HashMap<String, ArrayList<DTDNode>>();
        HashMap<String, DTDNode> elementMap = new HashMap<String, DTDNode>();
        while ((index = source.indexOf("<!", last)) >= 0) {
            String[] dim;
            String text;
            if (source.startsWith("<!ELEMENT", index)) {
                text = source.substring(index, source.indexOf(">", index) + 1);
                text = text.replaceAll("\\s+", " ");
                dim = text.split(" ");
                DTDNode node = new DTDNode(index, text, "_icon_element");
                elementMap.put(dim[1], node);
                this.root.add(node);
            } else if (source.startsWith("<!ATTLIST", index)) {
                text = source.substring(index, source.indexOf(">", index) + 1);
                dim = (text = text.replaceAll("\\s+", " ")).split(" ");
                ArrayList<DTDNode> list = (ArrayList<DTDNode>)attrMap.get(dim[1]);
                if (list == null) {
                    list = new ArrayList<DTDNode>();
                    attrMap.put(dim[1], list);
                }
                list.add(new DTDNode(index, text, "_icon_attlist"));
            } else if (source.startsWith("<!ENTITY", index)) {
                text = source.substring(index, source.indexOf(">", index) + 1);
                text = text.replaceAll("\\s+", " ");
                this.root.add(new DTDNode(index, text, "_icon_entity"));
            } else if (source.startsWith("<!NOTATION", index)) {
                text = source.substring(index, source.indexOf(">", index) + 1);
                text = text.replaceAll("\\s+", " ");
                this.root.add(new DTDNode(index, text, "_icon_notate"));
            }
            last = index + 2;
        }
        Iterator ite = attrMap.entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry entry = ite.next();
            String key = (String)entry.getKey();
            List attrs = (List)entry.getValue();
            DTDNode element = (DTDNode)elementMap.get(key);
            int i = 0;
            while (i < attrs.size()) {
                DTDNode attr = (DTDNode)attrs.get(i);
                if (element == null) {
                    this.root.add(attr);
                } else {
                    element.addChild(attr);
                }
                ++i;
            }
        }
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            viewer.refresh();
        }
    }

    private class DTDRootNode {
        private List children = new ArrayList();

        DTDRootNode() {
        }

        public void add(DTDNode node) {
            this.children.add(node);
        }

        public DTDNode[] getChildren() {
            return this.children.toArray(new DTDNode[this.children.size()]);
        }

        public void clear() {
            this.children.clear();
        }
    }

    private class DTDNode {
        private int position;
        private String text;
        private String image;
        private List children = new ArrayList();
        private DTDNode parent;

        public DTDNode(int position, String text, String image) {
            this.position = position;
            this.text = text;
            this.image = image;
        }

        public int getPosition() {
            return this.position;
        }

        public void addChild(DTDNode node) {
            this.children.add(node);
        }

        public DTDNode[] getChildren() {
            return this.children.toArray(new DTDNode[this.children.size()]);
        }

        public void setParent(DTDNode parent) {
            this.parent = parent;
        }

        public DTDNode getParent() {
            return this.parent;
        }

        public String toString() {
            return this.text;
        }

        public String getImage() {
            return this.image;
        }
    }

    private class DTDContentProvider
    implements ITreeContentProvider {
        DTDContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof DTDRootNode) {
                return ((DTDRootNode)parentElement).getChildren();
            }
            if (parentElement instanceof DTDNode) {
                return ((DTDNode)parentElement).getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof DTDNode) {
                DTDNode parent = ((DTDNode)element).getParent();
                if (parent == null) {
                    return DTDOutlinePage.this.root;
                }
                return parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class DTDLabelProvider
    extends LabelProvider {
        DTDLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof DTDNode) {
                return HTMLPlugin.getDefault().getImageRegistry().get(((DTDNode)element).getImage());
            }
            return null;
        }
    }

    private class DTDSelectionChangedListener
    implements ISelectionChangedListener {
        DTDSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            Object element = sel.getFirstElement();
            if (element instanceof DTDNode) {
                int offset = ((DTDNode)element).getPosition();
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = page.getActiveEditor();
                if (editorPart instanceof DTDEditor) {
                    ((DTDEditor)editorPart).selectAndReveal(offset, 0);
                }
            }
        }
    }
}

