/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.TableViewerSupport;
import tk.eclipse.plugin.htmleditor.assist.CustomAttribute;
import tk.eclipse.plugin.htmleditor.assist.CustomElement;

public class CustomAssistPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer attributeTableViewer;
    private TableViewer elementTableViewer;
    private List elementModel = new ArrayList();
    private List attributeModel = new ArrayList();

    public CustomAssistPreferencePage() {
        super("CustomAssist");
        this.setPreferenceStore(HTMLPlugin.getDefault().getPreferenceStore());
        this.setDescription(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.CustomAssist.Desc"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem elementTab = new TabItem(tabFolder, 0);
        elementTab.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.CustomElements"));
        elementTab.setControl(this.createElementArea(tabFolder));
        TabItem attributeTab = new TabItem(tabFolder, 0);
        attributeTab.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.CustomAttributes"));
        attributeTab.setControl(this.createAttributeArea(tabFolder));
        this.attributeModel.addAll(CustomAttribute.loadFromPreference(false));
        this.attributeTableViewer.refresh();
        this.elementModel.addAll(CustomElement.loadFromPreference(false));
        this.elementTableViewer.refresh();
        return composite;
    }

    private Control createElementArea(TabFolder tabFolder) {
        TableViewerSupport support = new TableViewerSupport(this.elementModel, (Composite)tabFolder){

            protected void initTableViewer(TableViewer viewer) {
                Table table = viewer.getTable();
                TableColumn col1 = new TableColumn(table, 0);
                col1.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.DisplayName"));
                col1.setWidth(100);
                TableColumn col2 = new TableColumn(table, 0);
                col2.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.AssistString"));
                col2.setWidth(200);
            }

            protected Object doAdd() {
                CustomElementDialog dialog = new CustomElementDialog(CustomAssistPreferencePage.this.getShell());
                if (dialog.open() == 0) {
                    return dialog.getCustomElement();
                }
                return null;
            }

            protected void doEdit(Object obj) {
                CustomElement element = (CustomElement)obj;
                CustomElementDialog dialog = new CustomElementDialog(CustomAssistPreferencePage.this.getShell(), element);
                if (dialog.open() == 0) {
                    CustomElement newElement = dialog.getCustomElement();
                    element.setDisplayName(newElement.getDisplayName());
                    element.setAssistString(newElement.getAssistString());
                }
            }

            protected ITableLabelProvider createLabelProvider() {
                return new CustomAssistLabelProvider();
            }
        };
        this.elementTableViewer = support.getTableViewer();
        return support.getControl();
    }

    private Control createAttributeArea(TabFolder tabFolder) {
        TableViewerSupport support = new TableViewerSupport(this.attributeModel, (Composite)tabFolder){

            protected void initTableViewer(TableViewer viewer) {
                Table table = viewer.getTable();
                TableColumn col1 = new TableColumn(table, 0);
                col1.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.TargetTag"));
                col1.setWidth(100);
                TableColumn col2 = new TableColumn(table, 0);
                col2.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.AttributeName"));
                col2.setWidth(200);
            }

            protected Object doAdd() {
                CustomAttributeDialog dialog = new CustomAttributeDialog(CustomAssistPreferencePage.this.getShell());
                if (dialog.open() == 0) {
                    return dialog.getCustomAttribute();
                }
                return null;
            }

            protected void doEdit(Object obj) {
                CustomAttribute attrInfo = (CustomAttribute)obj;
                CustomAttributeDialog dialog = new CustomAttributeDialog(CustomAssistPreferencePage.this.getShell(), attrInfo);
                if (dialog.open() == 0) {
                    CustomAttribute newAttrInfo = dialog.getCustomAttribute();
                    attrInfo.setTargetTag(newAttrInfo.getTargetTag());
                    attrInfo.setAttributeName(newAttrInfo.getAttributeName());
                }
            }

            protected ITableLabelProvider createLabelProvider() {
                return new CustomAssistLabelProvider();
            }
        };
        this.attributeTableViewer = support.getTableViewer();
        return support.getControl();
    }

    protected void performDefaults() {
        this.attributeModel.clear();
        this.attributeModel.addAll(CustomAttribute.loadFromPreference(true));
        this.attributeTableViewer.refresh();
        this.elementModel.clear();
        this.elementModel.addAll(CustomElement.loadFromPreference(true));
        this.elementTableViewer.refresh();
    }

    public boolean performOk() {
        CustomAttribute.saveToPreference(this.attributeModel);
        CustomElement.saveToPreference(this.elementModel);
        return true;
    }

    private class CustomAssistLabelProvider
    implements ITableLabelProvider {
        CustomAssistLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof CustomAttribute) {
                CustomAttribute attr = (CustomAttribute)element;
                if (columnIndex == 0) {
                    return attr.getTargetTag();
                }
                if (columnIndex == 1) {
                    return attr.getAttributeName();
                }
            } else if (element instanceof CustomElement) {
                CustomElement elem = (CustomElement)element;
                if (columnIndex == 0) {
                    return elem.getDisplayName();
                }
                if (columnIndex == 1) {
                    return elem.getAssistString();
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class CustomElementDialog
    extends Dialog {
        private Text displayName;
        private Text assistString;
        private CustomElement element;

        public CustomElementDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        public CustomElementDialog(Shell parentShell, CustomElement element) {
            super(parentShell);
            this.element = element;
        }

        protected Point getInitialSize() {
            Point size = super.getInitialSize();
            size.x = 300;
            return size;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.CustomElements"));
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            label.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Dialog.DisplayName"));
            this.displayName = new Text(composite, 2048);
            if (this.element != null) {
                this.displayName.setText(this.element.getDisplayName());
            }
            this.displayName.setLayoutData((Object)new GridData(768));
            label = new Label(composite, 0);
            label.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Dialog.AssistString"));
            this.assistString = new Text(composite, 2048);
            this.assistString.setLayoutData((Object)new GridData(768));
            if (this.element != null) {
                this.assistString.setText(this.element.getAssistString());
            }
            return composite;
        }

        protected void okPressed() {
            if (this.displayName.getText().length() == 0) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("HTMLEditorPreferencePage.DisplayName")}));
                return;
            }
            if (this.assistString.getText().length() == 0) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("HTMLEditorPreferencePage.AssistString")}));
                return;
            }
            this.element = new CustomElement(this.displayName.getText(), this.assistString.getText());
            super.okPressed();
        }

        public CustomElement getCustomElement() {
            return this.element;
        }
    }

    private class CustomAttributeDialog
    extends Dialog {
        private Text target;
        private Text name;
        private CustomAttribute attrInfo;

        public CustomAttributeDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        public CustomAttributeDialog(Shell parentShell, CustomAttribute attrInfo) {
            super(parentShell);
            this.attrInfo = attrInfo;
        }

        protected Point getInitialSize() {
            Point size = super.getInitialSize();
            size.x = 300;
            return size;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.CustomAttributes"));
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            label.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Dialog.TargetTag"));
            this.target = new Text(composite, 2048);
            if (this.attrInfo != null) {
                this.target.setText(this.attrInfo.getTargetTag());
            } else {
                this.target.setText("*");
            }
            this.target.setLayoutData((Object)new GridData(768));
            label = new Label(composite, 0);
            label.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Dialog.AttributeName"));
            this.name = new Text(composite, 2048);
            this.name.setLayoutData((Object)new GridData(768));
            if (this.attrInfo != null) {
                this.name.setText(this.attrInfo.getAttributeName());
            }
            return composite;
        }

        protected void okPressed() {
            if (this.target.getText().length() == 0) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("HTMLEditorPreferencePage.TargetTag")}));
                return;
            }
            if (this.name.getText().length() == 0) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("HTMLEditorPreferencePage.AttributeName")}));
                return;
            }
            this.attrInfo = new CustomAttribute(this.target.getText(), this.name.getText());
            super.okPressed();
        }

        public CustomAttribute getCustomAttribute() {
            return this.attrInfo;
        }
    }
}

