/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import tk.eclipse.plugin.htmleditor.ColorProvider;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.editors.HTMLAnnotationHover;
import tk.eclipse.plugin.htmleditor.editors.HTMLDoubleClickStrategy;
import tk.eclipse.plugin.htmleditor.editors.HTMLScanner;
import tk.eclipse.plugin.htmleditor.editors.HTMLTagScanner;

public class HTMLConfiguration
extends SourceViewerConfiguration {
    private HTMLDoubleClickStrategy doubleClickStrategy;
    private HTMLScanner scanner;
    private HTMLTagScanner tagScanner;
    private RuleBasedScanner commentScanner;
    private RuleBasedScanner scriptScanner;
    private RuleBasedScanner doctypeScanner;
    private RuleBasedScanner directiveScanner;
    private ColorProvider colorProvider;
    private IEditorPart editor;
    private ContentAssistant assistant;
    private HTMLAssistProcessor processor;

    public HTMLConfiguration(ColorProvider colorProvider) {
        this.colorProvider = colorProvider;
    }

    public void setEditorPart(IEditorPart editor) {
        this.editor = editor;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(this.editor);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__html_comment", "__html_tag", "__html_script", "__html_doctype", "__html_directive"};
    }

    public HTMLAssistProcessor getAssistProcessor() {
        if (this.processor == null) {
            this.processor = this.createAssistProcessor();
        }
        return this.processor;
    }

    protected HTMLAssistProcessor createAssistProcessor() {
        HTMLAssistProcessor processor = new HTMLAssistProcessor();
        return processor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.assistant == null) {
            this.assistant = new ContentAssistant();
            this.assistant.setInformationControlCreator(new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent);
                }
            });
            this.assistant.setContextInformationPopupOrientation(20);
            this.assistant.enableAutoInsert(true);
            HTMLAssistProcessor processor = this.getAssistProcessor();
            this.assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
            this.assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__html_tag");
            this.assistant.install((ITextViewer)sourceViewer);
            IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
            this.assistant.enableAutoActivation(store.getBoolean("_pref_assist_auto"));
            this.assistant.setAutoActivationDelay(store.getInt("_pref_assist_times"));
            processor.setAutoAssistChars(store.getString("_pref_assist_chars").toCharArray());
            processor.setAssistCloseTag(store.getBoolean("_pref_assist_close"));
        }
        return this.assistant;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new HTMLDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected HTMLScanner getHTMLScanner() {
        if (this.scanner == null) {
            this.scanner = new HTMLScanner(this.colorProvider);
            this.scanner.setDefaultReturnToken(this.colorProvider.getToken("__pref_color_foreground"));
        }
        return this.scanner;
    }

    protected HTMLTagScanner getTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new HTMLTagScanner(this.colorProvider);
            this.tagScanner.setDefaultReturnToken(this.colorProvider.getToken("_pref_color_tag"));
        }
        return this.tagScanner;
    }

    protected RuleBasedScanner getCommentScanner() {
        if (this.commentScanner == null) {
            this.commentScanner = new RuleBasedScanner();
            this.commentScanner.setDefaultReturnToken(this.colorProvider.getToken("_pref_color_comment"));
        }
        return this.commentScanner;
    }

    protected RuleBasedScanner getScriptScanner() {
        if (this.scriptScanner == null) {
            this.scriptScanner = new RuleBasedScanner();
            this.scriptScanner.setDefaultReturnToken(this.colorProvider.getToken("_pref_color_scriptlet"));
        }
        return this.scriptScanner;
    }

    protected RuleBasedScanner getDirectiveScanner() {
        if (this.directiveScanner == null) {
            this.directiveScanner = new RuleBasedScanner();
            this.directiveScanner.setDefaultReturnToken(this.colorProvider.getToken("_pref_color_scriptlet"));
        }
        return this.directiveScanner;
    }

    protected RuleBasedScanner getDoctypeScanner() {
        if (this.doctypeScanner == null) {
            this.doctypeScanner = new RuleBasedScanner();
            this.doctypeScanner.setDefaultReturnToken(this.colorProvider.getToken("_pref_color_doctype"));
        }
        return this.doctypeScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        HTMLTagDamagerRepairer dr = null;
        dr = new HTMLTagDamagerRepairer((ITokenScanner)this.getTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getHTMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getScriptScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_script");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_script");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getDoctypeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_doctype");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_doctype");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getDirectiveScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_directive");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_directive");
        return reconciler;
    }

    protected ColorProvider getColorProvider() {
        return this.colorProvider;
    }

    private class HTMLTagDamagerRepairer
    extends DefaultDamagerRepairer {
        public HTMLTagDamagerRepairer(ITokenScanner scanner) {
            super(scanner);
        }

        public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
            if (!documentPartitioningChanged) {
                String source = this.fDocument.get();
                int start = source.substring(0, e.getOffset()).lastIndexOf(60);
                if (start == -1) {
                    start = 0;
                }
                int end = source.indexOf(62, e.getOffset());
                int end2 = e.getOffset() + (e.getText() == null ? e.getLength() : e.getText().length());
                end = end == -1 ? source.length() : (end2 > end ? end2 : ++end);
                return new Region(start, end - start);
            }
            return partition;
        }
    }
}

