/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;

public class JavaScriptValidator {
    private IFile file;

    public JavaScriptValidator(IFile file) {
        this.file = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doValidate() {
        Context context = Context.enter();
        try {
            try {
                this.file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                HTMLProjectParams params = new HTMLProjectParams(this.file.getProject());
                if (!params.getValidateJavaScript()) {
                    return;
                }
                context.setErrorReporter((ErrorReporter)new ErrorReporterImpl());
                context.initStandardObjects();
                context.compileString(new String(HTMLUtil.readStream(this.file.getContents()), this.file.getCharset()), this.file.getName(), 1, null);
                return;
            }
            finally {
                Context.exit();
            }
        }
        catch (EvaluatorException params) {
            return;
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
            return;
        }
    }

    private class ErrorReporterImpl
    implements ErrorReporter {
        ErrorReporterImpl() {
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            HTMLUtil.addMarker((IResource)JavaScriptValidator.this.file, 2, line, message);
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            HTMLUtil.addMarker((IResource)JavaScriptValidator.this.file, 1, line, message);
        }
    }
}

