/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.TableViewerSupport;

public class JavaScriptLibraryTable {
    public static final String PREFIX = "entry:";
    private TableViewer tableViewer;
    private List tableModel = new ArrayList();
    private Composite composite;
    private Button add;
    private Button addExternal;
    private Button remove;

    public JavaScriptLibraryTable(final Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.composite.setLayoutData((Object)new GridData(1808));
        this.tableViewer = new TableViewer(this.composite);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        this.tableViewer.getTable().setLayoutData((Object)gd);
        this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaScriptLibraryTable.this.remove.setEnabled(JavaScriptLibraryTable.this.tableViewer.getTable().getSelectionCount() != 0);
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new TableViewerSupport.ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                if (element instanceof File) {
                    return HTMLPlugin.getDefault().getImageRegistry().get("_icon_jar");
                }
                if (element instanceof IFile) {
                    return HTMLPlugin.getDefault().getImageRegistry().get("_icon_jar_ext");
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof File) {
                    return ((File)element).getAbsolutePath();
                }
                if (element instanceof IFile) {
                    return ((IFile)element).getFullPath().toString();
                }
                return element.toString();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.tableViewer.setInput((Object)this.tableModel);
        Composite buttons = new Composite(this.composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(2));
        this.add = new Button(buttons, 8);
        this.add.setText(HTMLPlugin.getResourceString("Button.Add"));
        this.add.setLayoutData((Object)JavaScriptLibraryTable.createButtonGridData());
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(HTMLPlugin.getResourceString("JavaScriptPropertyPage.ChooseJavaScript"));
                dialog.setMessage(HTMLPlugin.getResourceString("JavaScriptPropertyPage.ChooseJavaScript.Description"));
                dialog.setInput((Object)wsroot);
                dialog.setValidator(new ISelectionStatusValidator(this){
                    private IStatus okStatus;
                    private IStatus ngStatus;
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                        this.okStatus = new Status(0, HTMLPlugin.getDefault().getPluginId(), 0, "", null);
                        this.ngStatus = new Status(4, HTMLPlugin.getDefault().getPluginId(), 4, "", null);
                    }

                    public IStatus validate(Object[] selection) {
                        int i = 0;
                        while (i < selection.length) {
                            if (!(selection[i] instanceof IFile)) {
                                return this.ngStatus;
                            }
                            if (!((IFile)selection[i]).getName().endsWith(".js")) {
                                return this.ngStatus;
                            }
                            ++i;
                        }
                        if (selection.length == 0) {
                            return this.ngStatus;
                        }
                        return this.okStatus;
                    }
                });
                if (dialog.open() == 0) {
                    Object[] results = dialog.getResult();
                    int i = 0;
                    while (i < results.length) {
                        JavaScriptLibraryTable.this.tableModel.add((IFile)results[i]);
                        ++i;
                    }
                    JavaScriptLibraryTable.this.tableViewer.refresh();
                    JavaScriptLibraryTable.this.modelChanged();
                }
            }
        });
        this.addExternal = new Button(buttons, 8);
        this.addExternal.setText(HTMLPlugin.getResourceString("Button.AddExternal"));
        this.addExternal.setLayoutData((Object)JavaScriptLibraryTable.createButtonGridData());
        this.addExternal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog dialog = new FileDialog(parent.getShell(), 4098);
                dialog.setFilterExtensions(new String[]{"*.js"});
                String result = dialog.open();
                if (result != null) {
                    String dir = dialog.getFilterPath();
                    String[] fileNames = dialog.getFileNames();
                    int i = 0;
                    while (i < fileNames.length) {
                        JavaScriptLibraryTable.this.tableModel.add(new File(dir, fileNames[i]));
                        ++i;
                    }
                    JavaScriptLibraryTable.this.tableViewer.refresh();
                    JavaScriptLibraryTable.this.modelChanged();
                }
            }
        });
        this.remove = new Button(buttons, 8);
        this.remove.setText(HTMLPlugin.getResourceString("Button.Remove"));
        this.remove.setLayoutData((Object)JavaScriptLibraryTable.createButtonGridData());
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IStructuredSelection sel = (IStructuredSelection)JavaScriptLibraryTable.this.tableViewer.getSelection();
                JavaScriptLibraryTable.this.tableModel.removeAll(sel.toList());
                JavaScriptLibraryTable.this.remove.setEnabled(false);
                JavaScriptLibraryTable.this.tableViewer.refresh();
                JavaScriptLibraryTable.this.modelChanged();
            }
        });
        this.remove.setEnabled(false);
    }

    protected void modelChanged() {
    }

    public Control getControl() {
        return this.composite;
    }

    public List getModel() {
        return this.tableModel;
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    private static GridData createButtonGridData() {
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        return gd;
    }
}

