/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;

public class TLDSAXHandler
extends DefaultHandler {
    private int mode = 0;
    private String prevTag = null;
    private boolean hasBody = true;
    private ArrayList attributes = new ArrayList();
    private HashMap attrRequiredMap = new HashMap();
    private HashMap attrDescMap = new HashMap();
    private String uri = null;
    private StringBuffer tagName = new StringBuffer();
    private StringBuffer attrName = new StringBuffer();
    private StringBuffer tagDesc = new StringBuffer();
    private StringBuffer attrDesc = new StringBuffer();
    private String prefix = "";
    private ArrayList result = new ArrayList();

    public TLDSAXHandler(String prefix) {
        this.prefix = prefix;
    }

    public TLDSAXHandler() {
        this.prefix = null;
    }

    public String getUri() {
        return this.uri;
    }

    public List getResult() {
        return this.result;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("tag")) {
            this.tagDesc.setLength(0);
            this.mode = 1;
        } else if (qName.equals("attribute")) {
            this.attrDesc.setLength(0);
            this.mode = 2;
        }
        this.prevTag = qName;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("tag")) {
            TagInfo info = new TagInfo(this.tagName.toString(), this.hasBody);
            int i = 0;
            while (i < this.attributes.size()) {
                String attrName = (String)this.attributes.get(i);
                boolean required = false;
                if (this.attrRequiredMap.get(attrName) != null) {
                    required = true;
                }
                AttributeInfo attrInfo = new AttributeInfo(attrName, true, 0, required);
                if (this.attrDescMap.get(attrName) != null) {
                    attrInfo.setDescription(TLDSAXHandler.wrap((String)this.attrDescMap.get(attrName)));
                }
                info.addAttributeInfo(attrInfo);
                ++i;
            }
            if (this.tagDesc.length() > 0) {
                info.setDescription(TLDSAXHandler.wrap(this.tagDesc.toString()));
            }
            this.result.add(info);
            this.mode = 0;
            this.prevTag = null;
            this.hasBody = true;
            this.attrRequiredMap.clear();
            this.attrDescMap.clear();
            this.tagName.setLength(0);
            this.tagDesc.setLength(0);
            this.attributes.clear();
        } else if (qName.equals("name") && this.mode == 2) {
            this.attributes.add(this.attrName.toString());
            this.attrName.setLength(0);
        } else if (qName.equals("description") && this.mode == 2 && this.attrDesc.length() > 0) {
            this.attrDescMap.put(this.attributes.get(this.attributes.size() - 1), this.attrDesc.toString());
            this.attrDesc.setLength(0);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuffer sb = new StringBuffer();
        int i = start;
        while (i < start + length) {
            sb.append(ch[i]);
            ++i;
        }
        String value = sb.toString().trim();
        if (!value.equals("")) {
            if (this.prevTag.equals("name")) {
                if (this.mode == 1) {
                    if (this.tagName.length() == 0) {
                        this.tagName.append(String.valueOf(this.prefix) + ":");
                    }
                    this.tagName.append(value);
                } else {
                    this.attrName.append(value);
                }
            } else if (this.prevTag.equals("bodycontent")) {
                this.hasBody = !value.equals("empty");
            } else if (this.prevTag.equals("required")) {
                if (value.equals("true")) {
                    this.attrRequiredMap.put(this.attributes.get(this.attributes.size() - 1), "true");
                }
            } else if (this.prevTag.equals("uri")) {
                this.uri = value;
            } else if (this.prefix == null && (this.prevTag.equals("shortname") || this.prevTag.equals("short-name"))) {
                this.prefix = value;
            } else if (this.prevTag.equals("description")) {
                if (this.mode == 1) {
                    this.tagDesc.append(value);
                } else if (this.mode == 2) {
                    this.attrDesc.append(value);
                }
            }
        }
    }

    private static String wrap(String text) {
        StringBuffer sb = new StringBuffer();
        int word = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (word > 40 && (c == ' ' || c == '\t')) {
                sb.append('\n');
                word = 0;
            } else {
                sb.append(c);
                ++word;
            }
            ++i;
        }
        return sb.toString();
    }
}

