/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts;

import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import tk.eclipse.plugin.struts.StrutsConfigResolver;
import tk.eclipse.plugin.struts.StrutsConfigSAXHandler;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.models.RootModel;

public class StrutsConfigXML2Model {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RootModel createModel(InputStream in, RootModel oldModel, IFile resource) {
        StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
        try {
            if (oldModel == null) return new RootModel();
            List oldModels = oldModel.getViasualChildren();
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            spfactory.setValidating(false);
            SAXParser parser = spfactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            StrutsConfigSAXHandler handler = new StrutsConfigSAXHandler((IResource)resource, oldModels);
            reader.setEntityResolver(new StrutsConfigResolver());
            reader.setContentHandler(handler);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            reader.parse(new InputSource(in));
            RootModel root = handler.getModel();
            root.setCharset(resource.getCharset());
            if (root.getCharset() == null || root.getCharset().length() == 0) {
                root.setCharset("UTF-8");
            }
            RootModel rootModel = root;
            return rootModel;
        }
        catch (Exception ex) {
            Util.logException(ex);
            return new RootModel();
        }
        finally {
            StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
        }
    }
}

