/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.MultiPageStrutsConfigEditor;
import tk.eclipse.plugin.struts.editors.models.AbstractModel;
import tk.eclipse.plugin.struts.editors.models.ActionMappingsModel;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.ControllerModel;
import tk.eclipse.plugin.struts.editors.models.DataSourceModel;
import tk.eclipse.plugin.struts.editors.models.DataSourcesModel;
import tk.eclipse.plugin.struts.editors.models.DirectForwardModel;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;
import tk.eclipse.plugin.struts.editors.models.FormBeanModel;
import tk.eclipse.plugin.struts.editors.models.FormBeansModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionsModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardsModel;
import tk.eclipse.plugin.struts.editors.models.IncludeModel;
import tk.eclipse.plugin.struts.editors.models.InputModel;
import tk.eclipse.plugin.struts.editors.models.MessageResourcesModel;
import tk.eclipse.plugin.struts.editors.models.PluginModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;

public class StrutsConfigOutlinePage
extends ContentOutlinePage
implements PropertyChangeListener {
    private MultiPageStrutsConfigEditor editor;
    private RootModel root;
    private boolean updating = false;
    private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
    private AddDataSourceAction addDataSourceAction = new AddDataSourceAction();
    private AddGlobalForwardAction addGlobalForwardAction = new AddGlobalForwardAction();
    private AddGlobalExceptionAction addGlobalExceptionAction = new AddGlobalExceptionAction();
    private AddFormBeanAction addFormBeanAction = new AddFormBeanAction();
    private AddPluginAction addPluginAction = new AddPluginAction();
    private AddMessageResourcesAction addMessageResourcesAction = new AddMessageResourcesAction();
    private DeleteItemAction deleteItemAction = new DeleteItemAction();
    private OpenAction openAction = new OpenAction();

    public StrutsConfigOutlinePage(MultiPageStrutsConfigEditor editor) {
        this.editor = editor;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.updating) {
            return;
        }
        if (evt.getPropertyName() == "_constraint") {
            return;
        }
        this.updating = true;
        this.update();
        this.editor.syncEditors(0);
        this.updating = false;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        final TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new StrutsConfigContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new StrutsConfigLabelProvider());
        this.update();
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                IStructuredSelection sel = (IStructuredSelection)evt.getSelection();
                StrutsConfigOutlinePage.this.addDataSourceAction.update(sel);
                StrutsConfigOutlinePage.this.addGlobalForwardAction.update(sel);
                StrutsConfigOutlinePage.this.addGlobalExceptionAction.update(sel);
                StrutsConfigOutlinePage.this.addFormBeanAction.update(sel);
                StrutsConfigOutlinePage.this.addPluginAction.update(sel);
                StrutsConfigOutlinePage.this.addMessageResourcesAction.update(sel);
                StrutsConfigOutlinePage.this.deleteItemAction.update(sel);
                StrutsConfigOutlinePage.this.openAction.update(sel);
            }
        });
        viewer.setSelection((ISelection)new StructuredSelection((Object)((RootModel)viewer.getInput()).getDataSourcesModel()));
        viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ISelection sel = viewer.getSelection();
                if (sel == null || !(sel instanceof IStructuredSelection)) {
                    return;
                }
                Object obj = ((IStructuredSelection)sel).getFirstElement();
                if (obj instanceof ActionModel || obj instanceof FormBeanModel) {
                    StrutsConfigOutlinePage.this.openAction.run();
                }
            }
        });
        MenuManager menu = new MenuManager();
        viewer.getTree().setMenu(menu.createContextMenu((Control)viewer.getTree()));
        menu.add((IAction)this.openAction);
        menu.add((IContributionItem)new Separator());
        MenuManager add = new MenuManager(this.resource.getString("outline.menu.add"));
        menu.add((IContributionItem)add);
        add.add((IAction)this.addDataSourceAction);
        add.add((IAction)this.addGlobalForwardAction);
        add.add((IAction)this.addGlobalExceptionAction);
        add.add((IAction)this.addFormBeanAction);
        add.add((IAction)this.addPluginAction);
        add.add((IAction)this.addMessageResourcesAction);
        menu.add((IAction)this.deleteItemAction);
    }

    public void update() {
        if (this.root != null) {
            this.removeOutlinePropertyListener(this.root);
        }
        TreeViewer viewer = this.getTreeViewer();
        this.root = this.editor.getRoot();
        if (viewer != null) {
            viewer.getTree().setRedraw(false);
            IStructuredSelection sel = (IStructuredSelection)this.getSelection();
            Object obj = sel.getFirstElement();
            this.setSelection(null);
            viewer.setInput((Object)this.root);
            viewer.refresh();
            viewer.expandAll();
            if (obj != null) {
                this.setSelection((ISelection)new StructuredSelection(obj));
            }
            viewer.getTree().setRedraw(true);
            this.setOutlinePropertyListener(this.root);
        }
    }

    private void setOutlinePropertyListener(RootModel root) {
        List children = root.getChildren();
        int i = 0;
        while (i < children.size()) {
            Object obj = children.get(i);
            if (obj instanceof AbstractModel) {
                ((AbstractModel)obj).addPropertyChangeListener(this);
            }
            ++i;
        }
        root.getDataSourcesModel().addPropertyChangeListener(this);
        root.getGlobalForwardsModel().addPropertyChangeListener(this);
        root.getGlobalExceptionsModel().addPropertyChangeListener(this);
        root.getActionMappingsModel().addPropertyChangeListener(this);
    }

    private void removeOutlinePropertyListener(RootModel root) {
        List children = root.getChildren();
        int i = 0;
        while (i < children.size()) {
            Object obj = children.get(i);
            if (obj instanceof AbstractModel) {
                ((AbstractModel)obj).removePropertyChangeListener(this);
            }
            ++i;
        }
        root.getGlobalForwardsModel().removePropertyChangeListener(this);
        root.getGlobalExceptionsModel().removePropertyChangeListener(this);
        root.getActionMappingsModel().removePropertyChangeListener(this);
    }

    private class AddDataSourceAction
    extends Action {
        public AddDataSourceAction() {
            super("data-source", StrutsPlugin.getDefault().getDescriptor("__icon_data_source"));
        }

        public void update(IStructuredSelection sel) {
            Object obj = sel.getFirstElement();
            this.setEnabled(obj != null && obj instanceof DataSourcesModel);
        }

        public void run() {
            DataSourceModel model = new DataSourceModel();
            StrutsConfigOutlinePage.this.root.addChild(model);
            StrutsConfigOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)model));
        }
    }

    private class AddGlobalForwardAction
    extends Action {
        public AddGlobalForwardAction() {
            super("global-forward", StrutsPlugin.getDefault().getDescriptor("__icon_forward"));
        }

        public void update(IStructuredSelection sel) {
            Object obj = sel.getFirstElement();
            this.setEnabled(obj != null && obj instanceof GlobalForwardsModel);
        }

        public void run() {
            GlobalForwardModel model = new GlobalForwardModel();
            StrutsConfigOutlinePage.this.root.addChild(model);
            StrutsConfigOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)model));
        }
    }

    private class AddGlobalExceptionAction
    extends Action {
        public AddGlobalExceptionAction() {
            super("global-exception", StrutsPlugin.getDefault().getDescriptor("__icon_exception"));
        }

        public void update(IStructuredSelection sel) {
            Object obj = sel.getFirstElement();
            this.setEnabled(obj != null && obj instanceof GlobalExceptionsModel);
        }

        public void run() {
            GlobalExceptionModel model = new GlobalExceptionModel();
            StrutsConfigOutlinePage.this.root.addChild(model);
            StrutsConfigOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)model));
        }
    }

    private class AddFormBeanAction
    extends Action {
        public AddFormBeanAction() {
            super("form-bean", StrutsPlugin.getDefault().getDescriptor("__icon_bean"));
        }

        public void update(IStructuredSelection sel) {
            Object obj = sel.getFirstElement();
            this.setEnabled(obj != null && obj instanceof FormBeansModel);
        }

        public void run() {
            FormBeanModel model = new FormBeanModel();
            StrutsConfigOutlinePage.this.root.addChild(model);
            StrutsConfigOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)model));
        }
    }

    private class AddPluginAction
    extends Action {
        public AddPluginAction() {
            super("plug-in", StrutsPlugin.getDefault().getDescriptor("__icon_plugin"));
        }

        public void update(IStructuredSelection sel) {
            this.setEnabled(true);
        }

        public void run() {
            PluginModel model = new PluginModel();
            StrutsConfigOutlinePage.this.root.addChild(model);
            StrutsConfigOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)model));
        }
    }

    private class AddMessageResourcesAction
    extends Action {
        public AddMessageResourcesAction() {
            super("message-resources", StrutsPlugin.getDefault().getDescriptor("__icon_webpage"));
        }

        public void update(IStructuredSelection sel) {
            this.setEnabled(true);
        }

        public void run() {
            MessageResourcesModel model = new MessageResourcesModel();
            StrutsConfigOutlinePage.this.root.addChild(model);
            StrutsConfigOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)model));
        }
    }

    private class DeleteItemAction
    extends Action {
        private Object target;

        public DeleteItemAction() {
            super(StrutsConfigOutlinePage.this.resource.getString("outline.menu.remove"));
        }

        public void update(IStructuredSelection sel) {
            Object obj = sel.getFirstElement();
            if (obj != null && (obj instanceof FormBeanModel || obj instanceof ActionModel || obj instanceof GlobalForwardModel || obj instanceof GlobalExceptionModel || obj instanceof PluginModel || obj instanceof MessageResourcesModel || obj instanceof ForwardModel || obj instanceof ExceptionModel || obj instanceof DataSourceModel)) {
                this.setEnabled(true);
                this.target = obj;
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (this.target instanceof FormBeanModel || this.target instanceof ActionModel || this.target instanceof GlobalForwardModel || this.target instanceof GlobalExceptionModel || this.target instanceof PluginModel || this.target instanceof MessageResourcesModel || this.target instanceof DataSourceModel) {
                StrutsConfigOutlinePage.this.root.removeChild(this.target);
            } else if (this.target instanceof ForwardModel) {
                ForwardModel model = (ForwardModel)this.target;
                model.detachSource();
                model.detachTarget();
            } else if (this.target instanceof ExceptionModel) {
                ExceptionModel model = (ExceptionModel)this.target;
                model.detachSource();
                model.detachTarget();
            }
        }
    }

    private class OpenAction
    extends Action {
        private Object target;

        public OpenAction() {
            super(StrutsConfigOutlinePage.this.resource.getString("outline.menu.open"));
        }

        public void update(IStructuredSelection sel) {
            Object obj = sel.getFirstElement();
            if (obj != null) {
                AbstractModel model;
                if (obj instanceof FormBeanModel && !((FormBeanModel)(model = (FormBeanModel)obj)).getType().equals("") && ((FormBeanModel)model).getType().indexOf(123) < 0) {
                    this.setEnabled(true);
                    this.target = obj;
                    return;
                }
                if (obj instanceof ActionModel && !((ActionModel)(model = (ActionModel)obj)).getType().equals("") && ((ActionModel)model).getType().indexOf(123) < 0) {
                    this.setEnabled(true);
                    this.target = obj;
                    return;
                }
            }
            this.setEnabled(false);
        }

        public void run() {
            String type = null;
            if (this.target instanceof ActionModel) {
                type = ((ActionModel)this.target).getType();
            } else if (this.target instanceof FormBeanModel) {
                type = ((FormBeanModel)this.target).getType();
            }
            if (type == null || type.equals("")) {
                Util.openAlertDialog(StrutsConfigOutlinePage.this.resource.getString("error.noClassName"));
                return;
            }
            try {
                String path = String.valueOf(type.replaceAll("\\.", "/")) + ".java";
                IProject project = ((IFileEditorInput)StrutsConfigOutlinePage.this.editor.getEditorInput()).getFile().getProject();
                IFile file = project.getFile(path);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IClasspathEntry[] entry = javaProject.getRawClasspath();
                int i = 0;
                while (i < entry.length) {
                    if (entry[i].getEntryKind() == 3) {
                        file = project.getFile(entry[i].getPath().removeFirstSegments(1).append(path));
                        break;
                    }
                    ++i;
                }
                if (file.exists()) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file, (boolean)true);
                } else if (this.target instanceof ActionModel) {
                    Util.openActionWizard(project, type);
                } else if (this.target instanceof FormBeanModel) {
                    Util.openActionFormWizard(project, type);
                }
            }
            catch (Exception ex) {
                Util.openErrorDialog(ex);
            }
        }
    }

    private class StrutsConfigContentProvider
    implements ITreeContentProvider {
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;

        StrutsConfigContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            List<FormBeansModel> list;
            block30: {
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    block29: {
                                        list = new ArrayList<AbstractModel>();
                                        if (!(parent instanceof RootModel)) break block29;
                                        RootModel rootModel = (RootModel)parent;
                                        list.add((FormBeansModel)((Object)rootModel.getDataSourcesModel()));
                                        list.add((FormBeansModel)((Object)rootModel.getGlobalForwardsModel()));
                                        list.add((FormBeansModel)((Object)rootModel.getGlobalExceptionsModel()));
                                        list.add(rootModel.getFormBeansModel());
                                        list.add((FormBeansModel)((Object)rootModel.getActionMappingsModel()));
                                        List children = StrutsConfigOutlinePage.this.root.getChildren();
                                        int i = 0;
                                        while (i < children.size()) {
                                            Object obj = children.get(i);
                                            if (obj instanceof ControllerModel) {
                                                list.add((FormBeansModel)obj);
                                            } else if (obj instanceof MessageResourcesModel) {
                                                list.add((FormBeansModel)obj);
                                            } else if (obj instanceof PluginModel) {
                                                list.add((FormBeansModel)obj);
                                            }
                                            ++i;
                                        }
                                        break block30;
                                    }
                                    if (!(parent instanceof DataSourcesModel)) break block31;
                                    List list2 = StrutsConfigOutlinePage.this.root.getChildren();
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        try {
                                            clazz = class$0 = Class.forName("tk.eclipse.plugin.struts.editors.models.DataSourceModel");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    list = Util.filtering(list2, clazz);
                                    break block30;
                                }
                                if (!(parent instanceof GlobalForwardsModel)) break block32;
                                List list3 = StrutsConfigOutlinePage.this.root.getChildren();
                                Class<?> clazz = class$1;
                                if (clazz == null) {
                                    try {
                                        clazz = class$1 = Class.forName("tk.eclipse.plugin.struts.editors.models.GlobalForwardModel");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                list = Util.filtering(list3, clazz);
                                break block30;
                            }
                            if (!(parent instanceof GlobalExceptionsModel)) break block33;
                            List list4 = StrutsConfigOutlinePage.this.root.getChildren();
                            Class<?> clazz = class$2;
                            if (clazz == null) {
                                try {
                                    clazz = class$2 = Class.forName("tk.eclipse.plugin.struts.editors.models.GlobalExceptionModel");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            list = Util.filtering(list4, clazz);
                            break block30;
                        }
                        if (!(parent instanceof FormBeansModel)) break block34;
                        List list5 = StrutsConfigOutlinePage.this.root.getChildren();
                        Class<?> clazz = class$3;
                        if (clazz == null) {
                            try {
                                clazz = class$3 = Class.forName("tk.eclipse.plugin.struts.editors.models.FormBeanModel");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        list = Util.filtering(list5, clazz);
                        break block30;
                    }
                    if (!(parent instanceof ActionMappingsModel)) break block35;
                    List list6 = StrutsConfigOutlinePage.this.root.getChildren();
                    Class<?> clazz = class$4;
                    if (clazz == null) {
                        try {
                            clazz = class$4 = Class.forName("tk.eclipse.plugin.struts.editors.models.ActionModel");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    list = Util.filtering(list6, clazz);
                    break block30;
                }
                if (!(parent instanceof ActionModel)) break block30;
                List conns = ((ActionModel)parent).getModelSourceConnections();
                list = new ArrayList(conns);
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Object model = it.next();
                    if (model instanceof DirectForwardModel) {
                        it.remove();
                        continue;
                    }
                    if (model instanceof IncludeModel) {
                        it.remove();
                        continue;
                    }
                    if (!(model instanceof InputModel)) continue;
                    it.remove();
                }
            }
            return list.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class StrutsConfigLabelProvider
    extends LabelProvider {
        StrutsConfigLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ActionModel) {
                return StrutsPlugin.getDefault().getImage("__icon_action");
            }
            if (element instanceof ForwardModel) {
                return StrutsPlugin.getDefault().getImage("__icon_forward");
            }
            if (element instanceof FormBeanModel) {
                return StrutsPlugin.getDefault().getImage("__icon_bean");
            }
            if (element instanceof FormBeansModel) {
                return StrutsPlugin.getDefault().getImage("__icon_beans");
            }
            if (element instanceof ActionMappingsModel) {
                return StrutsPlugin.getDefault().getImage("__icon_actions");
            }
            if (element instanceof GlobalForwardsModel) {
                return StrutsPlugin.getDefault().getImage("__icon_globals");
            }
            if (element instanceof ControllerModel) {
                return StrutsPlugin.getDefault().getImage("__icon_controller");
            }
            if (element instanceof MessageResourcesModel) {
                return StrutsPlugin.getDefault().getImage("__icon_webpage");
            }
            if (element instanceof PluginModel) {
                return StrutsPlugin.getDefault().getImage("__icon_plugin");
            }
            if (element instanceof GlobalForwardModel) {
                return StrutsPlugin.getDefault().getImage("__icon_forward");
            }
            if (element instanceof GlobalExceptionsModel) {
                return StrutsPlugin.getDefault().getImage("__icon_global_exceptions");
            }
            if (element instanceof GlobalExceptionModel || element instanceof ExceptionModel) {
                return StrutsPlugin.getDefault().getImage("__icon_exception");
            }
            if (element instanceof DataSourcesModel) {
                return StrutsPlugin.getDefault().getImage("__icon_data_sources");
            }
            if (element instanceof DataSourceModel) {
                return StrutsPlugin.getDefault().getImage("__icon_data_source");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ActionModel) {
                String path = ((ActionModel)element).getPath();
                if (path.equals("")) {
                    return "<action>";
                }
                return path;
            }
            if (element instanceof ForwardModel) {
                String name = ((ForwardModel)element).getName();
                if (name.equals("")) {
                    return "<forward>";
                }
                return name;
            }
            if (element instanceof FormBeanModel) {
                String name = ((FormBeanModel)element).getName();
                if (name.equals("")) {
                    return "<form-bean>";
                }
                return name;
            }
            if (element instanceof ControllerModel) {
                return "controller";
            }
            if (element instanceof MessageResourcesModel) {
                return "message-resources";
            }
            if (element instanceof PluginModel) {
                return "plug-in";
            }
            if (element instanceof GlobalForwardModel) {
                String name = ((GlobalForwardModel)element).getName();
                if (name.equals("")) {
                    name = "<forward>";
                }
                return name;
            }
            if (element instanceof GlobalExceptionModel) {
                String type = ((GlobalExceptionModel)element).getType();
                if (type.equals("")) {
                    type = "<exception>";
                }
                return type;
            }
            if (element instanceof ExceptionModel) {
                String type = ((ExceptionModel)element).getType();
                if (type.equals("")) {
                    type = "<exception>";
                }
                return type;
            }
            if (element instanceof DataSourceModel) {
                String type = ((DataSourceModel)element).getType();
                if (type.equals("")) {
                    type = "<data-source>";
                }
                return type;
            }
            if (element instanceof GlobalForwardsModel) {
                return "global-forwards";
            }
            if (element instanceof GlobalExceptionsModel) {
                return "global-exceptions";
            }
            if (element instanceof ActionMappingsModel) {
                return "action-mappings";
            }
            if (element instanceof DataSourcesModel) {
                return "data-sources";
            }
            if (element instanceof FormBeansModel) {
                return "form-beans";
            }
            return super.getText(element);
        }
    }
}

