package net.java.amateras.uml.java;

import java.util.ArrayList;
import java.util.List;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.ClassModel;
import net.java.amateras.uml.classdiagram.model.InterfaceModel;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.RootModel;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.jdt.core.IType;

/**
 * 
 * @author Naoki Takezoe
 */
public class ImportClassModelCommand extends Command {
	
	private IType[] types;
	private RootModel root;
	private List models;
	private Point location;
	
	public ImportClassModelCommand(RootModel root,IType type){
		this(root, new IType[]{ type });
	}
	
	public ImportClassModelCommand(RootModel root,IType[] types){
		this.root = root;
		this.types = types;
	}
	
	public void setLocation(Point location){
		this.location = location;
	}
	
	public void execute(){
		models = new ArrayList();
		for(int i=0;i<types.length;i++){
			AbstractUMLEntityModel entity = createModel(types[i]);
			if(entity != null){
				if(location!=null){
					entity.setConstraint(new Rectangle(
							location.x + (i * 10), 
							location.y + (i * 10), -1, -1));
				} else {
					entity.setConstraint(new Rectangle(10, 10, -1, -1));
				}
				root.copyPresentation(entity);
				root.addChild(entity);
				models.add(entity);
			}
		}
	}
	
	private AbstractUMLEntityModel createModel(IType type){
		try {
			if(type.isInterface()){
				InterfaceModel model = new InterfaceModel();
				model.setName(type.getFullyQualifiedName());
				AttributeModel[] fields = UMLJavaUtils.getFields(type);
				for(int i=0;i<fields.length;i++){
					model.addChild(fields[i]);
				}
				OperationModel[] methods = UMLJavaUtils.getMethods(type);
				for(int i=0;i<methods.length;i++){
					model.addChild(methods[i]);
				}
				UMLJavaUtils.appendInterfacesConnection(this.root, type, model);
				return model;
			} else if(type.isClass()){
				ClassModel model = new ClassModel();
				model.setName(type.getFullyQualifiedName());
				AttributeModel[] attrs = UMLJavaUtils.getFields(type);
				for(int i=0;i<attrs.length;i++){
					model.addChild(attrs[i]);
				}
				OperationModel[] methods = UMLJavaUtils.getMethods(type);
				for(int i=0;i<methods.length;i++){
					model.addChild(methods[i]);
				}
				UMLJavaUtils.appendSuperClassConnection(this.root, type, model);
				UMLJavaUtils.appendInterfacesConnection(this.root, type, model);
				return model;
			}
		} catch(Exception ex){
			UMLPlugin.logException(ex);
		}
		return null;
	}
	
	public void undo(){
		for(int i=0;i<models.size();i++){
			AbstractUMLEntityModel model = (AbstractUMLEntityModel)models.get(i);
			List conns = model.getModelSourceConnections();
			for(int j=0;j<conns.size();j++){
				AbstractUMLConnectionModel conn = (AbstractUMLConnectionModel) conns.get(j);
				conn.detachSource();
				conn.detachTarget();
			}
			this.root.removeChild(model);
		}
	}
}
