package net.java.amateras.uml;

import org.eclipse.draw2d.PositionConstants;
import org.eclipse.gef.ui.actions.ActionBarContributor;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentRetargetAction;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gef.ui.actions.ZoomInRetargetAction;
import org.eclipse.gef.ui.actions.ZoomOutRetargetAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;

public class DiagramEditorContributor extends ActionBarContributor {

	protected void buildActions() {
	    addRetargetAction(new UndoRetargetAction());
	    addRetargetAction(new RedoRetargetAction());
	    addRetargetAction(new DeleteRetargetAction());
	    addRetargetAction(new ZoomInRetargetAction());
	    addRetargetAction(new ZoomOutRetargetAction());
	    addRetargetAction(new AlignmentRetargetAction(PositionConstants.TOP));
	    addRetargetAction(new AlignmentRetargetAction(PositionConstants.MIDDLE));
	    addRetargetAction(new AlignmentRetargetAction(PositionConstants.BOTTOM));
	    addRetargetAction(new AlignmentRetargetAction(PositionConstants.LEFT));
	    addRetargetAction(new AlignmentRetargetAction(PositionConstants.CENTER));
	    addRetargetAction(new AlignmentRetargetAction(PositionConstants.RIGHT));
	}

	protected void declareGlobalActionKeys() {
	}
	
	public void setActiveEditor(IEditorPart editor) {
		ActionRegistry registry = (ActionRegistry)editor.getAdapter(ActionRegistry.class);
		
	    getActionBars().setGlobalActionHandler(
		    	ActionFactory.PRINT.getId(),
		    	registry.getAction(ActionFactory.PRINT.getId()));
		
	    super.setActiveEditor(editor);
	}
	
	public void contributeToToolBar(IToolBarManager toolBarManager) {
		toolBarManager.add(getAction(ActionFactory.DELETE.getId()));
		toolBarManager.add(getAction(ActionFactory.UNDO.getId()));
		toolBarManager.add(getAction(ActionFactory.REDO.getId()));
	    toolBarManager.add(new Separator());
	    toolBarManager.add(getActionRegistry().getAction(GEFActionConstants.ZOOM_IN));
	    toolBarManager.add(getActionRegistry().getAction(GEFActionConstants.ZOOM_OUT));
	    toolBarManager.add(new ZoomComboContributionItem(getPage()));
	}

}
