package net.java.amateras.uml;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class UMLPreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage {

	private Button direct;

	private Button manhattan;

	private Button fan;

	private Button shortest;

	private BooleanFieldEditor booleanEditor;

	private BooleanFieldEditor antiAlias;
	
	private BooleanFieldEditor showGrid;
	
	private SpinnerFieldEditor gridSize;
	
	private BooleanFieldEditor snapToGeometry;

	public UMLPreferencePage() {
		super("Amateras UML");
	}

	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		// for Connection Router
		Group routerGroup = new Group(composite, SWT.NULL);
		routerGroup.setText(UMLPlugin.getDefault().getResourceString("preference.router"));
		routerGroup.setLayout(new GridLayout(1, false));
		routerGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		direct = new Button(routerGroup, SWT.RADIO);
		direct.setImage(UMLPlugin.getImageDescriptor("icons/router_direct.gif")
				.createImage());

		manhattan = new Button(routerGroup, SWT.RADIO);
		manhattan.setImage(UMLPlugin.getImageDescriptor(
				"icons/router_manhattan.gif").createImage());

		fan = new Button(routerGroup, SWT.RADIO);
		fan.setImage(UMLPlugin.getImageDescriptor("icons/router_fan.gif")
				.createImage());

		shortest = new Button(routerGroup, SWT.RADIO);
		shortest.setImage(UMLPlugin.getImageDescriptor(
				"icons/router_shortest.gif").createImage());
		
		// for Diagram Layout (Grid)
		Group layoutGroup = new Group(composite, SWT.NULL);
		layoutGroup.setText(UMLPlugin.getDefault().getResourceString("preference.layout"));
		layoutGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		showGrid = new BooleanFieldEditor(UMLPlugin.PREF_SHOW_GRID, 
				UMLPlugin.getDefault().getResourceString("preference.layout.showGrid"), layoutGroup);
		gridSize = new SpinnerFieldEditor(UMLPlugin.PREF_GRID_SIZE, 
				UMLPlugin.getDefault().getResourceString("preference.layout.gridSize"), 1, 100, layoutGroup);
		snapToGeometry = new BooleanFieldEditor(UMLPlugin.PREF_SNAP_GEOMETRY, 
				UMLPlugin.getDefault().getResourceString("preference.layout.snapToGeometry"), layoutGroup);
		layoutGroup.setLayout(new GridLayout(3, false));
		
		// for Sequence Diagram
		Group sequenceGroup = new Group(composite, SWT.NULL);
		sequenceGroup.setText(UMLPlugin.getDefault().getResourceString(
				"preference.sequence"));
		sequenceGroup.setLayout(new GridLayout(1, false));
		sequenceGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		booleanEditor = new BooleanFieldEditor(UMLPlugin.PREF_CREATE_RETURN,
				UMLPlugin.getDefault().getResourceString(
						"preference.sequence.returnmessage"), sequenceGroup);
		
		antiAlias = new BooleanFieldEditor(UMLPlugin.PREF_ANTI_ALIAS,
				UMLPlugin.getDefault().getResourceString(
						"preference.antialias"), sequenceGroup);
		
		// Initializes values
		fillInitialValues();
		
		return composite;
	}

	private void fillInitialValues() {
		IPreferenceStore store = UMLPlugin.getDefault().getPreferenceStore();

		String router = store.getString(UMLPlugin.PREF_CONNECTION_TYPE);
		if (router.equals("manhattan")) {
			manhattan.setSelection(true);
		} else if (router.equals("fan")) {
			fan.setSelection(true);
		} else if (router.equals("shortest")) {
			shortest.setSelection(true);
		} else {
			direct.setSelection(true);
		}
		booleanEditor.setPreferenceStore(store);
		booleanEditor.load();

		antiAlias.setPreferenceStore(store);
		antiAlias.load();
		
		showGrid.setPreferenceStore(store);
		showGrid.load();
		
		gridSize.setPreferenceStore(store);
		gridSize.load();
		
		snapToGeometry.setPreferenceStore(store);
		snapToGeometry.load();
	}

	public boolean performOk() {
		IPreferenceStore store = UMLPlugin.getDefault().getPreferenceStore();

		if (manhattan.getSelection()) {
			store.setValue(UMLPlugin.PREF_CONNECTION_TYPE, "manhattan");
		} else if (fan.getSelection()) {
			store.setValue(UMLPlugin.PREF_CONNECTION_TYPE, "fan");
		} else if (shortest.getSelection()) {
			store.setValue(UMLPlugin.PREF_CONNECTION_TYPE, "shortest");
		} else {
			store.setValue(UMLPlugin.PREF_CONNECTION_TYPE, "direct");
		}
		booleanEditor.store();
		antiAlias.store();
		showGrid.store();
		gridSize.store();
		snapToGeometry.store();
		return true;
	}

	public void init(IWorkbench workbench) {
	}

}