package net.java.amateras.uml.classdiagram.action;

import java.util.List;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.action.AbstractUMLEditorAction;
import net.java.amateras.uml.classdiagram.editpart.AttributeEditPart;
import net.java.amateras.uml.classdiagram.editpart.OperationEditPart;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.editpart.AbstractUMLEntityEditPart;
import net.java.amateras.uml.model.AbstractUMLEntityModel;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AddOperationAction extends AbstractUMLEditorAction {

	private AbstractUMLEntityModel target;
	private CommandStack stack;
	
	public AddOperationAction(CommandStack stack, GraphicalViewer viewer){
		super(UMLPlugin.getDefault().getResourceString("menu.addOperation"), viewer);
		this.stack = stack;
	}
	
	public void update(IStructuredSelection sel){
		Object obj = sel.getFirstElement();
		if(obj!=null && obj instanceof AbstractUMLEntityEditPart){
			setEnabled(true);
			target = (AbstractUMLEntityModel)((AbstractUMLEntityEditPart)obj).getModel();
		} else if(obj!=null && obj instanceof OperationEditPart){
			setEnabled(true);
			target = (AbstractUMLEntityModel)((OperationEditPart)obj).getParent().getModel();
		} else if(obj!=null && obj instanceof AttributeEditPart){
			setEnabled(true);
			target = (AbstractUMLEntityModel)((AttributeEditPart)obj).getParent().getModel();
		} else {
			setEnabled(false);
			target = null;
		}
	}
	
	public void run(){
		stack.execute(new AddOperationCommand());
	}
	
	private class AddOperationCommand extends Command {
		
		private OperationModel operation;
		
		public void execute(){
			operation = new OperationModel();
			int count = 1;
			List list = target.getChildren();
			for(int i=0;i<list.size();i++){
				if(list.get(i) instanceof OperationModel){
					count++;
				}
			}
			operation.setName("operation" + count);
			target.copyPresentation(operation);
			target.addChild(operation);
		}
		
		public void undo() {
			target.removeChild(operation);
		}
	}

}
