package net.java.amateras.uml.classdiagram.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.classdiagram.figure.UMLClassFigure;
import net.java.amateras.uml.classdiagram.model.ClassModel;
import net.java.amateras.uml.editpart.AbstractUMLEntityEditPart;
import net.java.amateras.uml.model.RootModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class ClassEditPart extends AbstractUMLEntityEditPart {

	private Font normal = null;

	private Font italic = null;

	protected List getModelChildren() {
		ClassModel model = (ClassModel) getModel();
		return FilterUtil.getFilteredChildren(model);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		super.propertyChange(evt);
		if (evt.getPropertyName().equals(ClassModel.P_NAME)) {
			RenameUtil.rename((String) evt.getOldValue(), (String) evt
					.getNewValue(), (RootModel) getParent().getModel());
		} else if (evt.getPropertyName().equals(ClassModel.P_CHILDREN)) {
			refreshChildren();
		} else if (evt.getPropertyName().equals(ClassModel.P_FILTER)) {
			List list = new ArrayList(getChildren());
			for (Iterator iter = list.iterator(); iter.hasNext();) {
				EditPart element = (EditPart) iter.next();
				removeChild(element);
			}
			refreshChildren();
		}
	}

	protected IFigure createFigure() {
		ClassModel model = (ClassModel) getModel();

		UMLClassFigure figure = new UMLClassFigure(UMLPlugin
				.getImageDescriptor("icons/class.gif").createImage());

		Font font = ((AbstractGraphicalEditPart) getParent()).getFigure()
				.getFont();
		FontData fontData = font.getFontData()[0];
		this.normal = new Font(null, fontData.getName(), fontData.getHeight(),
				SWT.NULL);
		this.italic = new Font(null, fontData.getName(), fontData.getHeight(),
				SWT.ITALIC);

		figure.setClassName(model.getName());
		figure.setStereoType(model.getStereoType());
		if (model.isAbstract()) {
			figure.setFont(italic);
		} else {
			figure.setFont(normal);
		}

		return figure;
	}

	public void deactivate() {
		super.deactivate();
		normal.dispose();
		italic.dispose();
	}

	protected void refreshVisuals() {
		super.refreshVisuals();

		UMLClassFigure figure = (UMLClassFigure) getFigure();
		ClassModel model = (ClassModel) getModel();
		figure.setClassName(model.getName());
		figure.setStereoType(model.getStereoType());
		if (model.isAbstract()) {
			figure.setFont(italic);
		} else {
			figure.setFont(normal);
		}
	}

}
