package net.java.amateras.uml.classdiagram.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.EntityModel;
import net.java.amateras.uml.properties.BooleanPropertyDescriptor;

import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * NXfIuWFNgB
 * 
 * @author Naoki Takezoe
 */
public class ClassModel extends AbstractUMLEntityModel implements EntityModel,
		StereoTypeModel {

	public static final String P_NAME = "_class_name";

	public static final String P_ABSTRACT = "_abstract";

	public static final String P_FILTER = "_filter";

	private static final String P_ATTRIBUTES = "_attrs";

	private static final String P_OPERATIONS = "_operations";

	private String name = "";

	private String stereoType = "";

	private boolean isAbstract = false;

	private static int number = 1;

	public ClassModel() {
		setName("Class" + number);
		number++;
	}

	public void setName(String className) {
		String oldName = this.name;
		this.name = className;
		firePropertyChange(P_NAME, oldName, className);
	}

	public String getName() {
		return this.name;
	}

	public boolean isAbstract() {
		return isAbstract;
	}

	public void setAbstract(boolean isAbstract) {
		this.isAbstract = isAbstract;
		firePropertyChange(P_ABSTRACT, null, new Boolean(isAbstract));
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		return new IPropertyDescriptor[] {
				new TextPropertyDescriptor(StereoTypeModel.P_STEREO_TYPE,
						UMLPlugin.getDefault().getResourceString(
								"property.stereoType")),
				new TextPropertyDescriptor(P_NAME, UMLPlugin.getDefault()
						.getResourceString("property.name")),
				new BooleanPropertyDescriptor(P_ABSTRACT, UMLPlugin
						.getDefault().getResourceString("property.abstract")),
				new ColorPropertyDescriptor(P_BACKGROUND_COLOR, UMLPlugin
						.getDefault().getResourceString("property.background")),
				new PropertyDescriptor(P_ATTRIBUTES, UMLPlugin.getDefault()
						.getResourceString("property.attributes")),
				new PropertyDescriptor(P_OPERATIONS, UMLPlugin.getDefault()
						.getResourceString("property.operations")) };
	}

	public Object getPropertyValue(Object id) {
		if (id.equals(StereoTypeModel.P_STEREO_TYPE)) {
			return getStereoType();
		} else if (id.equals(P_NAME)) {
			return getName();
		} else if (id.equals(P_ABSTRACT)) {
			return new Boolean(isAbstract());
		} else if (id.equals(P_ATTRIBUTES)) {
			List rv = new ArrayList();
			for (Iterator iter = getChildren().iterator(); iter.hasNext();) {
				Object element = (Object) iter.next();
				if (element instanceof AttributeModel) {
					rv.add(element);
				}
			}
			return new ListPropertyWrapper(rv);
		} else if (id.equals(P_OPERATIONS)) {
			List rv = new ArrayList();
			for (Iterator iter = getChildren().iterator(); iter.hasNext();) {
				Object element = (Object) iter.next();
				if (element instanceof OperationModel) {
					rv.add(element);
				}
			}
			return new ListPropertyWrapper(rv);
		}
		return super.getPropertyValue(id);
	}

	public boolean isPropertySet(Object id) {
		if (id.equals(StereoTypeModel.P_STEREO_TYPE)) {
			return true;
		} else if (id.equals(P_NAME)) {
			return true;
		} else if (id.equals(P_ABSTRACT)) {
			return true;
		}
		return super.isPropertySet(id);
	}

	public void setPropertyValue(Object id, Object value) {
		if (id.equals(StereoTypeModel.P_STEREO_TYPE)) {
			setStereoType((String) value);
		} else if (id.equals(P_NAME)) {
			setName((String) value);
		} else if (id.equals(P_ABSTRACT)) {
			setAbstract(((Boolean) value).booleanValue());
		}
		super.setPropertyValue(id, value);
	}

	public String toString() {
		return getName();
	}

	public String getStereoType() {
		return stereoType == null ? "" : stereoType;
	}

	public void setStereoType(String stereoType) {
		this.stereoType = stereoType;
		firePropertyChange(StereoTypeModel.P_STEREO_TYPE, null, stereoType);
	}
}
