package net.java.amateras.uml.model;

import java.util.ArrayList;
import java.util.List;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.properties.BooleanPropertyDescriptor;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class AbstractUMLConnectionModel extends AbstractUMLModel {

	private AbstractUMLEntityModel source;

	private AbstractUMLEntityModel target;

	private List bendpoints = new ArrayList();

	private boolean useBendpoint = false;

	public static final String P_BEND_POINT = "_bend_point";

	public static final String P_USE_BEND_POINT = "_use_bendpoint";
	
	public void addBendpoint(int index, Point point) {
		bendpoints.add(index, point);
		firePropertyChange(P_BEND_POINT, null, null);
	}

	public void setUseBendpoint(boolean useBendpoint) {
		this.useBendpoint = useBendpoint;
		firePropertyChange(P_USE_BEND_POINT, null,new Boolean(this.useBendpoint));
	}
	
	public boolean isUseBendpoint() {
		return useBendpoint;
	}
	
	public List getBendpoints() {
		if (bendpoints == null) {
			bendpoints = new ArrayList();
		}
		return bendpoints;
	}

	public void removeBendpoint(int index) {
		bendpoints.remove(index);
		firePropertyChange(P_BEND_POINT, null, null);
	}

	// ̃xhE|Cg̒u(xhE|Cg̈ړɎgp)
	public void replaceBendpoint(int index, Point point) {
		bendpoints.set(index, point);
		firePropertyChange(P_BEND_POINT, null, null);
	}

	// ̃RlNV̍sourceɐڑ
	public void attachSource() {
		// ̃RlNVɐڑĂꍇ͖
		if (!source.getModelSourceConnections().contains(this)) {
			source.addSourceConnection(this);
		}
	}

	// ̃RlNV̐[targetɐڑ
	public void attachTarget() {
		if (!target.getModelTargetConnections().contains(this)) {
			target.addTargetConnection(this);
		}
	}

	// ̃RlNV̍sourceO
	public void detachSource() {
		if (source != null) {
			source.removeSourceConnection(this);
		}
	}

	// ̃RlNV̐[targetO
	public void detachTarget() {
		if (target != null) {
			target.removeTargetConnection(this);
		}
	}

	public AbstractUMLEntityModel getSource() {
		return source;
	}

	public AbstractUMLEntityModel getTarget() {
		return target;
	}

	public void setSource(AbstractUMLEntityModel model) {
		source = model;
	}

	public void setTarget(AbstractUMLEntityModel model) {
		target = model;
	}

	public Object getEditableValue() {
		return this;
	}

	public Object getPropertyValue(Object id) {
		if (id.equals(P_USE_BEND_POINT)) {
			return new Boolean(useBendpoint);
		}
		return super.getPropertyValue(id);
	}

	public boolean isPropertySet(Object id) {
		if (id.equals(P_USE_BEND_POINT)) {
			return true;
		}
		return super.isPropertySet(id);
	}

	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_USE_BEND_POINT)) {
			setUseBendpoint(((Boolean) value).booleanValue());
		} else {
			super.setPropertyValue(id, value);	
		}
	}
	
	public IPropertyDescriptor[] getPropertyDescriptors() {
		return new IPropertyDescriptor[] {
				new ColorPropertyDescriptor(P_FOREGROUND_COLOR, UMLPlugin
						.getDefault().getResourceString("property.foreground")),
						new BooleanPropertyDescriptor(P_USE_BEND_POINT, UMLPlugin
								.getDefault().getResourceString("property.bendpoint")) };
	}

}
