/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.jseditor.launch.JavaScriptLibraryTable;

public class JavaScriptPropertyPage
extends PropertyPage {
    private HTMLProjectParams params;
    private JavaScriptLibraryTable tableViewer;

    public JavaScriptPropertyPage() {
        this.setDescription(HTMLPlugin.getResourceString("JavaScriptPropertyPage.Description"));
    }

    protected Control createContents(Composite parent) {
        this.tableViewer = new JavaScriptLibraryTable(parent);
        try {
            this.params = new HTMLProjectParams(this.getProject());
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
        this.fillControls();
        return this.tableViewer.getControl();
    }

    private void fillControls() {
        List tableModel = this.tableViewer.getModel();
        tableModel.clear();
        String[] javaScripts = this.params.getJavaScripts();
        IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < javaScripts.length) {
            if (javaScripts[i].startsWith("entry:")) {
                IResource resource = wsroot.findMember(javaScripts[i].substring("entry:".length()));
                if (resource != null && resource instanceof IFile && resource.exists()) {
                    tableModel.add((IFile)resource);
                }
            } else {
                tableModel.add(new File(javaScripts[i]));
            }
            ++i;
        }
        this.tableViewer.refresh();
    }

    protected void performDefaults() {
        this.params = new HTMLProjectParams();
        this.fillControls();
    }

    public boolean performOk() {
        try {
            this.params = new HTMLProjectParams(this.getProject());
            List tableModel = this.tableViewer.getModel();
            String[] javaScripts = new String[tableModel.size()];
            int i = 0;
            while (i < tableModel.size()) {
                Object obj = tableModel.get(i);
                if (obj instanceof File) {
                    javaScripts[i] = ((File)obj).getAbsolutePath();
                } else if (obj instanceof IFile) {
                    javaScripts[i] = "entry:" + ((IFile)obj).getFullPath().toString();
                }
                ++i;
            }
            this.params.setJavaScripts(javaScripts);
            this.params.save(this.getProject());
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
            return false;
        }
        return true;
    }

    private IProject getProject() {
        return (IProject)this.getElement();
    }
}

