/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;

public class DocTypeRule
extends MultiLineRule {
    public DocTypeRule(IToken token) {
        super("<!DOCTYPE", ">", token);
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        boolean quoted = false;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        boolean previousWasEscapeCharacter = false;
        while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                scanner.read();
            } else if (c == 91) {
                quoted = true;
            } else if (c == 93) {
                quoted = false;
            } else if (this.fEndSequence.length > 0 && c == this.fEndSequence[0]) {
                if (!quoted && this.sequenceDetected(scanner, this.fEndSequence, true)) {
                    return true;
                }
            } else if (this.fBreaksOnEOL) {
                int i = 0;
                while (i < delimiters.length) {
                    if (!(c != delimiters[i][0] || !this.sequenceDetected(scanner, delimiters[i], true) || this.fEscapeContinuesLine && previousWasEscapeCharacter)) {
                        return true;
                    }
                    ++i;
                }
            }
            boolean bl = previousWasEscapeCharacter = c == this.fEscapeCharacter;
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        scanner.unread();
        return false;
    }
}

