/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.tidy.Tidy;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;

public class HTMLValidator
implements FuzzyXMLErrorListener {
    private String original;
    private String contents;
    private IFile file;
    private Pattern TIDY_ERROR = Pattern.compile("^line ([0-9]+?) column ([0-9]+?) - (.+?)$", 32);
    private boolean showXMLErrors;

    public HTMLValidator(IFile file) {
        this.file = file;
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        this.showXMLErrors = store.getBoolean("__pref_show_xml_errors");
    }

    public void doValidate() {
        try {
            if (this.validateUsingTidy()) {
                ByteArrayOutputStream out = null;
                try {
                    out = new ByteArrayOutputStream();
                    Tidy tidy = new Tidy();
                    tidy.setXHTML(false);
                    tidy.setCharEncoding(0);
                    tidy.setErrout(new PrintWriter(out, true));
                    tidy.parse(this.file.getContents(), null);
                    String errors = new String(out.toByteArray());
                    errors = errors.replaceAll("\r\n", "\n");
                    errors = errors.replaceAll("\r", "\n");
                    String[] dim = errors.split("\n");
                    int i = 0;
                    while (i < dim.length) {
                        Matcher matcher;
                        if (dim[i].startsWith("line") && (matcher = this.TIDY_ERROR.matcher(dim[i])).matches()) {
                            String message = matcher.group(3);
                            if (message.startsWith("Warning")) {
                                HTMLUtil.addMarker((IResource)this.file, 1, Integer.parseInt(matcher.group(1)), matcher.group(3));
                            } else {
                                HTMLUtil.addMarker((IResource)this.file, 2, Integer.parseInt(matcher.group(1)), matcher.group(3));
                            }
                        }
                        ++i;
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            if (this.validateUsingFuzzyXML()) {
                String contents;
                this.original = new String(HTMLUtil.readStream(this.file.getContents()), this.file.getCharset());
                this.contents = contents = HTMLUtil.scriptlet2space(this.original, false);
                this.contents = this.contents.replaceAll("\r\n", " \n");
                this.contents = this.contents.replaceAll("\r", "\n");
                FuzzyXMLParser parser = new FuzzyXMLParser();
                parser.addErrorListener((FuzzyXMLErrorListener)this);
                FuzzyXMLDocument doc = parser.parse(contents);
                this.validateDocument(doc);
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    protected boolean validateUsingTidy() {
        return true;
    }

    protected boolean validateUsingFuzzyXML() {
        return false;
    }

    protected void validateDocument(FuzzyXMLDocument doc) {
    }

    protected IFile getFile() {
        return this.file;
    }

    protected String getContent() {
        return this.original;
    }

    protected int getLineAtOffset(int offset) {
        String text = this.contents.substring(0, offset + 1);
        return text.split("\n").length;
    }

    public void error(FuzzyXMLErrorEvent event) {
        if (!this.showXMLErrors) {
            return;
        }
        int offset = event.getOffset();
        int length = event.getLength();
        String message = event.getMessage();
        HTMLUtil.addMarker((IResource)this.getFile(), 2, this.getLineAtOffset(offset), offset, length, message);
    }
}

