/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.gefutils;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public abstract class AbstractDialogPropertyDescriptor
extends PropertyDescriptor {
    public AbstractDialogPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        ValueCellEditor editor = new ValueCellEditor(parent);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    protected abstract Object openDialogBox(Object var1, Control var2);

    protected class ValueCellEditor
    extends CellEditor {
        private Text text;
        private Composite editor;
        private Button button;
        private boolean isSelection = false;
        private boolean isDeleteable = false;
        private boolean isSelectable = false;
        private Object value = null;

        public ValueCellEditor(Composite parent) {
            super(parent, 0);
        }

        protected Control createControl(Composite parent) {
            Font font = parent.getFont();
            Color bg = parent.getBackground();
            this.editor = new Composite(parent, this.getStyle());
            this.editor.setFont(font);
            this.editor.setBackground(bg);
            this.editor.setLayout((Layout)new DialogCellLayout());
            this.text = new Text(this.editor, 0);
            this.text.addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ ValueCellEditor this$1;
                {
                    this.this$1 = valueCellEditor;
                }

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u001b') {
                        ValueCellEditor.access$2(this.this$1);
                    } else if (e.character == '\r') {
                        String newValue = ValueCellEditor.access$1(this.this$1).getText();
                        ValueCellEditor.access$3(this.this$1, newValue);
                    }
                }

                public void keyPressed(KeyEvent e) {
                    ValueCellEditor.access$4(this.this$1);
                    ValueCellEditor.access$5(this.this$1);
                    ValueCellEditor.access$6(this.this$1);
                }
            });
            this.text.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ ValueCellEditor this$1;
                {
                    this.this$1 = valueCellEditor;
                }

                public void mouseUp(MouseEvent e) {
                    ValueCellEditor.access$4(this.this$1);
                    ValueCellEditor.access$5(this.this$1);
                    ValueCellEditor.access$6(this.this$1);
                }
            });
            this.text.addFocusListener((FocusListener)new FocusAdapter(this){
                final /* synthetic */ ValueCellEditor this$1;
                {
                    this.this$1 = valueCellEditor;
                }

                public void focusLost(FocusEvent e) {
                    String newValue = ValueCellEditor.access$1(this.this$1).getText();
                    ValueCellEditor.access$3(this.this$1, newValue);
                }
            });
            this.text.setFont(parent.getFont());
            this.text.setBackground(parent.getBackground());
            this.button = new Button(this.editor, 1024);
            this.button.setText("...");
            this.button.setFont(font);
            this.button.addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ ValueCellEditor this$1;
                {
                    this.this$1 = valueCellEditor;
                }

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u001b') {
                        ValueCellEditor.access$2(this.this$1);
                    }
                }
            });
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValueCellEditor this$1;
                {
                    this.this$1 = valueCellEditor;
                }

                public void widgetSelected(SelectionEvent event) {
                    Object newValue = this.this$1.openDialogBox((Control)ValueCellEditor.access$7(this.this$1));
                    if (newValue != null) {
                        ValueCellEditor.access$3(this.this$1, newValue);
                    }
                }
            });
            this.setValueValid(true);
            this.updateContents(this.value);
            return this.editor;
        }

        private void updateValue(Object newValue) {
            if (newValue != null) {
                boolean newValidState = this.isCorrect(newValue);
                if (newValidState) {
                    this.markDirty();
                    this.doSetValue(newValue);
                } else {
                    this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), newValue.toString()));
                }
                this.fireApplyEditorValue();
            }
        }

        protected Object doGetValue() {
            return this.value;
        }

        protected void doSetFocus() {
            this.button.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }

        protected void doSetValue(Object value) {
            this.value = value;
            this.updateContents(value);
        }

        private void checkDeleteable() {
            boolean oldIsDeleteable = this.isDeleteable;
            this.isDeleteable = this.isDeleteEnabled();
            if (oldIsDeleteable != this.isDeleteable) {
                this.fireEnablementChanged("delete");
            }
        }

        private void checkSelectable() {
            boolean oldIsSelectable = this.isSelectable;
            this.isSelectable = this.isSelectAllEnabled();
            if (oldIsSelectable != this.isSelectable) {
                this.fireEnablementChanged("selectall");
            }
        }

        private void checkSelection() {
            boolean oldIsSelection = this.isSelection;
            boolean bl = this.isSelection = this.text.getSelectionCount() > 0;
            if (oldIsSelection != this.isSelection) {
                this.fireEnablementChanged("copy");
                this.fireEnablementChanged("cut");
            }
        }

        public boolean isCopyEnabled() {
            if (this.text == null || this.text.isDisposed()) {
                return false;
            }
            return this.text.getSelectionCount() > 0;
        }

        public boolean isCutEnabled() {
            if (this.text == null || this.text.isDisposed()) {
                return false;
            }
            return this.text.getSelectionCount() > 0;
        }

        public boolean isDeleteEnabled() {
            if (this.text == null || this.text.isDisposed()) {
                return false;
            }
            return this.text.getSelectionCount() > 0 || this.text.getCaretPosition() < this.text.getCharCount();
        }

        public boolean isPasteEnabled() {
            return this.text != null && !this.text.isDisposed();
        }

        public boolean isSaveAllEnabled() {
            return this.text != null && !this.text.isDisposed();
        }

        public boolean isSelectAllEnabled() {
            if (this.text == null || this.text.isDisposed()) {
                return false;
            }
            return this.text.getCharCount() > 0;
        }

        public void performCopy() {
            this.text.copy();
        }

        public void performCut() {
            this.text.cut();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }

        public void performDelete() {
            if (this.text.getSelectionCount() > 0) {
                this.text.insert("");
            } else {
                int pos = this.text.getCaretPosition();
                if (pos < this.text.getCharCount()) {
                    this.text.setSelection(pos, pos + 1);
                    this.text.insert("");
                }
            }
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }

        public void performPaste() {
            this.text.paste();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }

        public void performSelectAll() {
            this.text.selectAll();
            this.checkSelection();
            this.checkDeleteable();
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            return AbstractDialogPropertyDescriptor.this.openDialogBox(this.value, cellEditorWindow);
        }

        protected void updateContents(Object value) {
            if (this.text == null) {
                return;
            }
            String text = "";
            if (value != null) {
                text = value.toString();
            }
            this.text.setText(text);
        }

        static /* synthetic */ void access$2(ValueCellEditor valueCellEditor) {
            valueCellEditor.fireCancelEditor();
        }

        static /* synthetic */ void access$3(ValueCellEditor valueCellEditor, Object object) {
            valueCellEditor.updateValue(object);
        }

        static /* synthetic */ void access$4(ValueCellEditor valueCellEditor) {
            valueCellEditor.checkSelection();
        }

        static /* synthetic */ void access$5(ValueCellEditor valueCellEditor) {
            valueCellEditor.checkDeleteable();
        }

        static /* synthetic */ void access$6(ValueCellEditor valueCellEditor) {
            valueCellEditor.checkSelectable();
        }

        static /* synthetic */ Composite access$7(ValueCellEditor valueCellEditor) {
            return valueCellEditor.editor;
        }

        private class DialogCellLayout
        extends Layout {
            private DialogCellLayout() {
            }

            public void layout(Composite editor, boolean force) {
                Rectangle bounds = editor.getClientArea();
                Point size = ValueCellEditor.this.button.computeSize(-1, -1, force);
                if (ValueCellEditor.this.text != null) {
                    ValueCellEditor.this.text.setBounds(0, 0, bounds.width - size.x, bounds.height);
                }
                ValueCellEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
            }

            public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
                if (wHint != -1 && hHint != -1) {
                    return new Point(wHint, hHint);
                }
                Point contentsSize = ValueCellEditor.this.text.computeSize(-1, -1, force);
                Point buttonSize = ValueCellEditor.this.button.computeSize(-1, -1, force);
                Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
                return result;
            }
        }
    }
}

