/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.views.IPaletteItem;

public class DefaultPaletteItem
implements IPaletteItem {
    private String name;
    private ImageDescriptor image;
    private String content;

    public DefaultPaletteItem(String name, ImageDescriptor image, String content) {
        this.name = name;
        this.image = image;
        this.content = content;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.image;
    }

    public String getLabel() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public void execute(HTMLSourceEditor editor) {
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        ITextSelection sel = (ITextSelection)editor.getSelectionProvider().getSelection();
        try {
            int caret = this.content.length();
            if (this.content.indexOf("></") != -1) {
                caret = this.content.indexOf("></") + 1;
            }
            doc.replace(sel.getOffset(), sel.getLength(), this.content);
            editor.selectAndReveal(sel.getOffset() + caret, 0);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }
}

