/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jseditor.editors.JavaScriptContext;
import tk.eclipse.plugin.jseditor.editors.JavaScriptElement;
import tk.eclipse.plugin.jseditor.editors.JavaScriptFunction;
import tk.eclipse.plugin.jseditor.editors.JavaScriptModel;

public class JavaScriptHyperlinkDetector
implements IHyperlinkDetector {
    private List functions = new ArrayList();

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        char c;
        String source = textViewer.getDocument().get();
        int offset = region.getOffset();
        String word = String.valueOf(source.charAt(offset));
        int index = offset - 1;
        while (index >= 0) {
            c = source.charAt(index);
            if (!Character.isJavaIdentifierPart(c)) break;
            word = String.valueOf(c) + word;
            --index;
        }
        index = offset + 1;
        offset = offset - word.length() + 1;
        while (source.length() > index) {
            c = source.charAt(index);
            if (Character.isJavaIdentifierPart(c)) {
                word = String.valueOf(word) + c;
                ++index;
                continue;
            }
            if (c == '(') break;
            return null;
        }
        JavaScriptModel model = new JavaScriptModel(source);
        JavaScriptContext context = model.getContextFromOffset(offset);
        if (context != null) {
            JavaScriptElement[] children = context.getVisibleElements();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof JavaScriptFunction) {
                    JavaScriptFunction function = (JavaScriptFunction)children[i];
                    if (children[i].getName().equals(word)) {
                        Region hyperlinkRegion = new Region(offset, word.length());
                        return new IHyperlink[]{new JavaScriptHyperlink((IRegion)hyperlinkRegion, textViewer, function.getOffset())};
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.functions.size()) {
            FunctionInfo info = (FunctionInfo)this.functions.get(i);
            if (info.function.getName().equals(word)) {
                Region hyperlinkRegion = new Region(offset, word.length());
                return new IHyperlink[]{new JavaScriptHyperlink((IRegion)hyperlinkRegion, info.resource, info.function.getOffset())};
            }
            ++i;
        }
        return null;
    }

    public void update(IFile file) {
        try {
            this.functions.clear();
            HTMLProjectParams params = new HTMLProjectParams(file.getProject());
            String[] javaScripts = params.getJavaScripts();
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < javaScripts.length) {
                InputStream in = null;
                File obj = null;
                if (javaScripts[i].startsWith("entry:")) {
                    IResource resource = wsroot.findMember(javaScripts[i].substring("entry:".length()));
                    if (resource != null && resource instanceof IFile && resource.exists()) {
                        in = ((IFile)resource).getContents();
                        obj = resource;
                    }
                } else {
                    obj = new File(javaScripts[i]);
                    in = new FileInputStream(javaScripts[i]);
                }
                String source = new String(HTMLUtil.readStream(in));
                JavaScriptModel model = new JavaScriptModel(source);
                JavaScriptElement[] elements = model.getChildren();
                int j = 0;
                while (j < elements.length) {
                    if (elements[j] instanceof JavaScriptFunction) {
                        FunctionInfo info = new FunctionInfo();
                        info.resource = obj;
                        info.function = (JavaScriptFunction)elements[j];
                        this.functions.add(info);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private class FunctionInfo {
        private Object resource;
        private JavaScriptFunction function;

        private FunctionInfo() {
        }
    }

    private class JavaScriptHyperlink
    implements IHyperlink {
        private IRegion region;
        private Object resource;
        private int beginOffset;
        static /* synthetic */ Class class$0;

        public JavaScriptHyperlink(IRegion region, Object resource, int beginOffset) {
            this.region = region;
            this.resource = resource;
            this.beginOffset = beginOffset;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return null;
        }

        public void open() {
            if (this.resource instanceof IFile) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IGotoMarker gotoMarker;
                    IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)this.resource), (boolean)true);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((gotoMarker = (IGotoMarker)editor.getAdapter((Class)clazz)) != null) {
                        IMarker marker = ((IFile)this.resource).createMarker("org.eclipse.core.resources.textmarker");
                        marker.setAttribute("charStart", this.beginOffset);
                        marker.setAttribute("charEnd", this.beginOffset);
                        gotoMarker.gotoMarker(marker);
                    }
                }
                catch (Exception ex) {
                    HTMLPlugin.logException(ex);
                }
            }
            if (this.resource instanceof ITextViewer) {
                ((ITextViewer)this.resource).setSelectedRange(this.beginOffset, 0);
            }
            boolean cfr_ignored_0 = this.resource instanceof File;
        }
    }
}

