/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.editors;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.jseditor.editors.JavaScriptContext;
import tk.eclipse.plugin.jseditor.editors.JavaScriptEditor;
import tk.eclipse.plugin.jseditor.editors.JavaScriptElement;
import tk.eclipse.plugin.jseditor.editors.JavaScriptFunction;
import tk.eclipse.plugin.jseditor.editors.JavaScriptModel;
import tk.eclipse.plugin.jseditor.editors.JavaScriptVariable;

public class JavaScriptOutlinePage
extends ContentOutlinePage {
    private JavaScriptModel model;
    private JavaScriptEditor editor;

    public JavaScriptOutlinePage(JavaScriptEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.model = new JavaScriptModel(this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get());
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new JavaScriptContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new JavaScriptLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)new JavaScriptSelectionChangedListener());
        viewer.setInput((Object)this.model);
        this.update();
    }

    public void update() {
        try {
            this.model.update(this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get());
            this.getTreeViewer().refresh();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class JavaScriptContentProvider
    implements ITreeContentProvider {
        private JavaScriptContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof JavaScriptContext) {
                return ((JavaScriptContext)parentElement).getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof JavaScriptContext) {
                return ((JavaScriptContext)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class JavaScriptSelectionChangedListener
    implements ISelectionChangedListener {
        private JavaScriptSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            JavaScriptElement func = (JavaScriptElement)sel.getFirstElement();
            if (func != null) {
                JavaScriptOutlinePage.this.editor.selectAndReveal(func.getOffset(), 0);
            }
        }
    }

    private class JavaScriptLabelProvider
    extends LabelProvider {
        private JavaScriptLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof JavaScriptFunction) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_function");
            }
            if (element instanceof JavaScriptVariable) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_variable");
            }
            return null;
        }
    }
}

