/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import tk.eclipse.plugin.jseditor.launch.JavaScriptLaunchConstants;
import tk.eclipse.plugin.jseditor.launch.JavaScriptLaunchUtil;

public class JavaScriptLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IVMInstall install = this.getVMInstall(configuration);
        IVMRunner runner = install.getVMRunner(launch.getLaunchMode());
        if (runner == null) {
            this.abort("VM not found", null, 106);
        }
        VMRunnerConfiguration runConfig = this.launchTypes(configuration, mode);
        this.setDefaultSourceLocator(launch, configuration);
        runner.run(runConfig, launch, monitor);
    }

    protected VMRunnerConfiguration launchTypes(ILaunchConfiguration configuration, String mode) throws CoreException {
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String vmArgs = this.getVMArguments(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, "");
        String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        JavaScriptLaunchUtil.copyLibraries();
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(JavaScriptLaunchConstants.JAVASCRIPT_EXECUTOR, JavaScriptLaunchUtil.getClassPathAsStringArray());
        ArrayList<String> args = new ArrayList<String>();
        String script = configuration.getAttribute("javascript.file", "");
        args.add(JavaScriptLaunchConfigurationDelegate.fixArgument(script));
        List includes = configuration.getAttribute("javascript.includes", Collections.EMPTY_LIST);
        IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < includes.size()) {
            String include = (String)includes.get(i);
            if (include.startsWith("entry:")) {
                IResource resource = wsroot.findMember(include.substring("entry:".length()));
                if (resource != null && resource instanceof IFile && resource.exists()) {
                    args.add(JavaScriptLaunchConfigurationDelegate.fixArgument(((IFile)resource).getLocation().toString()));
                }
            } else {
                args.add(JavaScriptLaunchConfigurationDelegate.fixArgument(include));
            }
            ++i;
        }
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setProgramArguments(args.toArray(new String[args.size()]));
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setEnvironment(envp);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        String[] bootpath = this.getBootpath(configuration);
        runConfig.setBootClassPath(bootpath);
        return runConfig;
    }

    private static String fixArgument(String arg) {
        if (arg.indexOf(32) >= 0) {
            return String.valueOf('\"') + arg + '\"';
        }
        return arg;
    }
}

